/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.Messages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class UseAsSourceFolderAction
extends Action {
    private IWorkbenchSite fSite;
    private IFolder[] fFolders;

    public UseAsSourceFolderAction(IWorkbenchSite site, IFolder[] folders) {
        if (folders.length == 0) {
            throw new IllegalArgumentException("empty folders array");
        }
        this.fSite = site;
        this.fFolders = folders;
        this.setText(Messages.LibraryFolderAction_UseAsSourceFolder_label);
        this.setImageDescriptor(PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT);
    }

    public void run() {
        boolean askForConfirmation = false;
        HashSet<IFolder> explicitlyDisabledFolders = new HashSet<IFolder>();
        LibraryFolderManager lfm = LibraryFolderManager.getInstance();
        IFolder[] iFolderArray = this.fFolders;
        int n = this.fFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            IFolder explicitlyDisabledParent = lfm.getExplicitlyDisabledParent((IResource)folder);
            explicitlyDisabledFolders.add(explicitlyDisabledParent);
            if (!folder.equals((Object)explicitlyDisabledParent)) {
                askForConfirmation = true;
            }
            ++n2;
        }
        final IFolder[] folders = explicitlyDisabledFolders.toArray(new IFolder[explicitlyDisabledFolders.size()]);
        if (askForConfirmation) {
            String title = Messages.LibraryFolderAction_Dialog_title;
            String message = NLS.bind((String)Messages.LibraryFolderAction_Dialog_description, (Object)StringUtils.join((Object[])this.getSortedPaths((IResource[])folders), (String)",\n\t"));
            if (!MessageDialog.openConfirm((Shell)this.fSite.getShell(), (String)title, (String)message)) {
                return;
            }
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                LibraryFolderManager.getInstance().useAsSourceFolder(folders, monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
    }

    private String[] getSortedPaths(IResource[] resources) {
        Object[] paths = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            paths[i] = resources[i].getFullPath().toString();
            ++i;
        }
        Arrays.sort(paths);
        return paths;
    }
}

