/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2IndexColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2IndexType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2UniqueRule;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class DB2IndexManager
extends SQLIndexManager<DB2Index, DB2TableBase> {
    private static final String CONS_IX_NAME = "%s_%s_IDX";
    private static final List<DBSIndexType> IX_TYPES = new ArrayList<DBSIndexType>(DB2IndexType.values().length);

    static {
        DB2IndexType[] dB2IndexTypeArray = DB2IndexType.values();
        int n = dB2IndexTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DB2IndexType db2IndexType = dB2IndexTypeArray[n2];
            if (db2IndexType.isValidForCreation().booleanValue()) {
                IX_TYPES.add(db2IndexType.getDBSIndexType());
            }
            ++n2;
        }
    }

    public boolean canEditObject(DB2Index object) {
        return false;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2Index> getObjectsCache(DB2Index object) {
        return ((DB2TableBase)object.getParentObject()).getSchema().getIndexCache();
    }

    protected DB2Index createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        final DB2TableBase table = (DB2TableBase)container;
        final DB2Index index = new DB2Index(table, "INDEX", DBSIndexType.UNKNOWN, DB2UniqueRule.U);
        return (DB2Index)((Object)new UITask<DB2Index>(){

            protected DB2Index runTask() {
                EditIndexPage editPage = new EditIndexPage(DB2Messages.edit_db2_index_manager_dialog_title, (DBSTableIndex)index, (Collection)IX_TYPES);
                if (!editPage.edit()) {
                    return null;
                }
                String tableName = CommonUtils.escapeIdentifier((String)table.getName());
                String colName = CommonUtils.escapeIdentifier((String)((DBSEntityAttribute)editPage.getSelectedAttributes().iterator().next()).getName());
                String indexBaseName = String.format(DB2IndexManager.CONS_IX_NAME, tableName, colName);
                String indexName = DBObjectNameCaseTransformer.transformName((DBPDataSource)table.getDataSource(), (String)indexBaseName);
                index.setName(indexName);
                index.setIndexType(editPage.getIndexType());
                index.setUniqueRule(editPage.isUnique() ? DB2UniqueRule.U : DB2UniqueRule.D);
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    index.addColumn(new DB2IndexColumn(index, (DB2TableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc"))));
                }
                return index;
            }
        }.execute());
    }
}

