/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDValueDefaultGenerator;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCBooleanValueHandler
extends JDBCAbstractValueHandler
implements DBDValueDefaultGenerator {
    public static final JDBCBooleanValueHandler INSTANCE = new JDBCBooleanValueHandler();
    private static final Log log = Log.getLog(JDBCBooleanValueHandler.class);

    @Override
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        boolean value = resultSet.getBoolean(index);
        return resultSet.wasNull() ? null : Boolean.valueOf(value);
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Boolean) {
            statement.setBoolean(paramIndex, (Boolean)value);
        } else if (value instanceof Number) {
            statement.setBoolean(paramIndex, ((Number)value).byteValue() != 0);
        } else {
            statement.setBoolean(paramIndex, Boolean.valueOf(value.toString()));
        }
    }

    @NotNull
    public Class<Boolean> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Boolean.class;
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        if (object instanceof Number) {
            if (((Number)object).byteValue() != 0) {
                return true;
            }
            return false;
        }
        log.warn("Unrecognized type '" + object.getClass().getName() + "' - can't convert to boolean");
        return null;
    }

    @Override
    public String getDefaultValueLabel() {
        return "False";
    }

    @Override
    public Object generateDefaultValue(DBCSession session, DBSTypedObject type) {
        return false;
    }
}

