/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.edit.prop;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyPersister;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyReflector;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyUpdater;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyValidator;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBECommandProperty<OBJECT_TYPE extends DBPObject>
extends DBECommandAbstract<OBJECT_TYPE> {
    private DBEPropertyHandler<OBJECT_TYPE> handler;
    private Object oldValue;
    private Object newValue;

    public DBECommandProperty(OBJECT_TYPE object, DBEPropertyHandler<OBJECT_TYPE> handler) {
        super(object, "Property '" + handler + "' change");
        this.handler = handler;
    }

    public DBECommandProperty(OBJECT_TYPE object, DBEPropertyHandler<OBJECT_TYPE> handler, Object oldValue, Object newValue) {
        this(object, handler);
        this.oldValue = oldValue;
        this.newValue = newValue;
        if (handler instanceof DBEPropertyReflector) {
            ((DBEPropertyReflector)handler).reflectValueChange(this.getObject(), oldValue, this.newValue);
        }
    }

    public DBEPropertyHandler<OBJECT_TYPE> getHandler() {
        return this.handler;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
        if (this.handler instanceof DBEPropertyReflector) {
            ((DBEPropertyReflector)this.handler).reflectValueChange(this.getObject(), this.oldValue, this.newValue);
        }
    }

    public void resetValue() {
        this.newValue = this.oldValue;
    }

    @Override
    public DBECommand<?> merge(DBECommand<?> prevCommand, Map<Object, Object> userParams) {
        DBECommandComposite<OBJECT_TYPE, DBEPropertyHandler<OBJECT_TYPE>> compositeCommand;
        if (prevCommand instanceof DBECommandProperty) {
            prevCommand.getObject();
            this.getObject();
        }
        if ((compositeCommand = (DBECommandComposite<OBJECT_TYPE, DBEPropertyHandler<OBJECT_TYPE>>)userParams.get(this.getObject())) == null) {
            compositeCommand = this.handler.createCompositeCommand(this.getObject());
            userParams.put(this.getObject(), compositeCommand);
        }
        compositeCommand.addPropertyHandler(this.handler, this.newValue);
        return compositeCommand;
    }

    @Override
    public void validateCommand(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.handler instanceof DBEPropertyValidator) {
            ((DBEPropertyValidator)this.handler).validate(this.getObject(), this.newValue);
        }
    }

    @Override
    public void updateModel() {
        if (this.handler instanceof DBEPropertyUpdater) {
            ((DBEPropertyUpdater)this.handler).updateModel(this.getObject(), this.newValue);
        }
    }

    @Override
    public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, Map<String, Object> options) {
        if (this.handler instanceof DBEPropertyPersister) {
            return ((DBEPropertyPersister)this.handler).getPersistActions(this.getObject(), this.newValue);
        }
        return null;
    }
}

