/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.utils.CommonUtils;

public class DBDRowIdentifier
implements DBPObject {
    private final DBSEntity entity;
    private final DBSEntityConstraint entityIdentifier;
    private final List<DBDAttributeBinding> attributes = new ArrayList<DBDAttributeBinding>();

    public DBDRowIdentifier(@NotNull DBSEntity entity, @NotNull DBSEntityConstraint entityIdentifier) {
        this.entity = entity;
        this.entityIdentifier = entityIdentifier;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public DBSEntity getEntity() {
        return this.entity;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public DBSEntityConstraint getUniqueKey() {
        return this.entityIdentifier;
    }

    @NotNull
    public String getKeyType() {
        return this.entityIdentifier.getConstraintType().getName();
    }

    @NotNull
    public List<DBDAttributeBinding> getAttributes() {
        return this.attributes;
    }

    public boolean isValidIdentifier() {
        return !(this.entityIdentifier instanceof DBSEntityReferrer) || !CommonUtils.isEmpty(this.attributes);
    }

    public void reloadAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBDAttributeBinding[] bindings) throws DBException {
        this.attributes.clear();
        if (this.entityIdentifier instanceof DBSEntityReferrer) {
            DBSEntityReferrer referrer = (DBSEntityReferrer)this.entityIdentifier;
            Collection refs = CommonUtils.safeCollection(referrer.getAttributeReferences(monitor));
            for (DBSEntityAttributeRef cColumn : refs) {
                DBDAttributeBinding binding = DBUtils.findBinding(bindings, (DBSAttributeBase)cColumn.getAttribute());
                if (binding != null) {
                    this.attributes.add(binding);
                    continue;
                }
                this.attributes.clear();
                break;
            }
        }
    }

    public void clearAttributes() {
        this.attributes.clear();
    }
}

