/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import com.ibm.icu.text.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionReader;
import org.eclipse.ltk.internal.core.refactoring.UndoableOperation2ChangeAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.xml.sax.InputSource;

public final class RefactoringHistoryService
implements IRefactoringHistoryService {
    private static RefactoringHistoryService fInstance = null;
    public static final String NAME_HISTORY_FILE = "refactorings.history";
    public static final String NAME_HISTORY_FOLDER = ".refactorings";
    public static final String NAME_INDEX_FILE = "refactorings.index";
    public static final String NAME_WORKSPACE_PROJECT = ".workspace";
    private static final NullRefactoringHistory NO_HISTORY = new NullRefactoringHistory();
    private final ListenerList<IRefactoringExecutionListener> fExecutionListeners = new ListenerList(0);
    private final ListenerList<IRefactoringHistoryListener> fHistoryListeners = new ListenerList(0);
    private IOperationHistoryListener fOperationListener = null;
    private long fOverrideTimeStamp = -1L;
    private int fReferenceCount = 0;
    private IResourceChangeListener fResourceListener = null;
    private static final int MAX_MANAGERS = 2;
    private final Map<IFileStore, RefactoringHistoryManager> fManagerCache = new LinkedHashMap<IFileStore, RefactoringHistoryManager>(2, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<IFileStore, RefactoringHistoryManager> entry) {
            return this.size() > 2;
        }
    };

    private static void filterRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, Set<RefactoringDescriptorProxy> set, boolean resolve, int flags, IProgressMonitor monitor) {
        Assert.isTrue((flags > 0 ? 1 : 0) != 0);
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, proxies.length);
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                int filter;
                RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (descriptor != null && ((filter = descriptor.getFlags()) | flags) == filter) {
                    if (resolve) {
                        set.add(new RefactoringDescriptorProxyAdapter(descriptor));
                    } else {
                        set.add(proxy);
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static RefactoringHistoryService getInstance() {
        if (fInstance == null) {
            fInstance = new RefactoringHistoryService();
        }
        return fInstance;
    }

    public static boolean hasSharedRefactoringHistory(IProject project) {
        Assert.isNotNull((Object)project);
        IScopeContext[] contexts = new IScopeContext[]{new ProjectScope(project)};
        String preference = Platform.getPreferencesService().getString(RefactoringCorePlugin.getPluginId(), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.FALSE.toString(), contexts);
        if (preference != null) {
            return Boolean.valueOf(preference);
        }
        return false;
    }

    public static void setSharedRefactoringHistory(IProject project, boolean enable, IProgressMonitor monitor) throws CoreException {
        block16: {
            Assert.isNotNull((Object)project);
            Assert.isTrue((boolean)project.isAccessible());
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask("", 300);
                String name = project.getName();
                URI uri = project.getLocationURI();
                if (uri == null) break block16;
                try {
                    IFileStore history = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER);
                    if (enable) {
                        IFileStore source = history.getChild(name);
                        if (source.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                            IFileStore destination = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                            if (destination.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                destination.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            }
                            destination.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.copy(destination, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        }
                    } else {
                        IFileStore source = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                        if (source.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                            IFileStore destination = history.getChild(name);
                            if (destination.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                destination.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            }
                            destination.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.copy(destination, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        }
                    }
                }
                finally {
                    if (enable) {
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    } else {
                        IFolder folder = project.getFolder(NAME_HISTORY_FOLDER);
                        if (folder.exists()) {
                            folder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        }
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private RefactoringHistoryService() {
    }

    @Override
    public void addExecutionListener(IRefactoringExecutionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fExecutionListeners.add((Object)listener);
    }

    @Override
    public void addHistoryListener(IRefactoringHistoryListener listener) {
        Assert.isNotNull((Object)listener);
        this.fHistoryListeners.add((Object)listener);
    }

    public void addRefactoringDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        Assert.isNotNull((Object)proxy);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fireRefactoringHistoryEvent(proxy, 4);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.fOperationListener = new IOperationHistoryListener(){

                public void historyNotification(OperationHistoryEvent event) {
                    RefactoringHistoryService.this.performHistoryNotification(event);
                }
            };
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.fOperationListener);
            this.fResourceListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    RefactoringHistoryService.this.peformResourceChanged(event);
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceListener, 3);
        }
    }

    public void deleteRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, proxies.length + 300);
            HashMap<String, ArrayList<RefactoringDescriptorProxy>> projects = new HashMap<String, ArrayList<RefactoringDescriptorProxy>>();
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayList<RefactoringDescriptorProxy> collection;
                RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                String project = proxy.getProject();
                if (project == null || "".equals(project)) {
                    project = NAME_WORKSPACE_PROJECT;
                }
                if ((collection = (ArrayList<RefactoringDescriptorProxy>)projects.get(project)) == null) {
                    collection = new ArrayList<RefactoringDescriptorProxy>();
                    projects.put(project, collection);
                }
                collection.add(proxy);
                monitor.worked(1);
                ++n2;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 300);
            try {
                Set entries = projects.entrySet();
                subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, entries.size());
                for (Map.Entry entry : entries) {
                    RefactoringHistoryManager manager;
                    Collection collection = (Collection)entry.getValue();
                    String project = (String)entry.getKey();
                    if (project.equals(NAME_WORKSPACE_PROJECT)) {
                        project = null;
                    }
                    if ((manager = this.getManager(project)) != null) {
                        manager.removeRefactoringDescriptors(collection.toArray(new RefactoringDescriptorProxy[collection.size()]), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1), RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings);
                        continue;
                    }
                    subMonitor.worked(1);
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void deleteRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IRefactoringDescriptorDeleteQuery query, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        Assert.isNotNull((Object)query);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, proxies.length + 300);
            HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>(proxies.length);
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                if (query.proceed(proxy).isOK()) {
                    set.add(proxy);
                }
                monitor.worked(1);
                ++n2;
            }
            if (!set.isEmpty()) {
                RefactoringDescriptorProxy[] delete = set.toArray(new RefactoringDescriptorProxy[set.size()]);
                this.deleteRefactoringDescriptors(delete, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                RefactoringDescriptorProxy[] refactoringDescriptorProxyArray2 = delete;
                int n3 = delete.length;
                n = 0;
                while (n < n3) {
                    RefactoringDescriptorProxy d = refactoringDescriptorProxyArray2[n];
                    this.fireRefactoringHistoryEvent(d, 3);
                    ++n;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void deleteRefactoringHistory(IProject project, IProgressMonitor monitor) throws CoreException {
        block8: {
            Assert.isNotNull((Object)project);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, 100);
                String name = project.getName();
                IFileStore stateStore = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation());
                if (name.equals(NAME_WORKSPACE_PROJECT)) {
                    IFileStore metaStore = stateStore.getChild(NAME_HISTORY_FOLDER).getChild(name);
                    metaStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    break block8;
                }
                URI uri = project.getLocationURI();
                if (uri == null || !project.isAccessible()) break block8;
                try {
                    IFileStore metaStore = stateStore.getChild(NAME_HISTORY_FOLDER).getChild(name);
                    metaStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    IFileStore projectStore = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                    projectStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                }
                finally {
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.fReferenceCount > 0) {
            this.fManagerCache.clear();
            --this.fReferenceCount;
        }
        if (this.fReferenceCount == 0) {
            if (this.fOperationListener != null) {
                OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.fOperationListener);
            }
            if (this.fResourceListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceListener);
            }
            this.fOperationListener = null;
        }
    }

    private void fireRefactoringExecutionEvent(final RefactoringDescriptorProxy proxy, final int eventType) {
        Assert.isNotNull((Object)proxy);
        for (final IRefactoringExecutionListener listener : this.fExecutionListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, eventType, proxy));
                }
            });
        }
    }

    private void fireRefactoringHistoryEvent(final RefactoringDescriptorProxy proxy, final int eventType) {
        Assert.isNotNull((Object)proxy);
        for (final IRefactoringHistoryListener listener : this.fHistoryListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.historyNotification(new RefactoringHistoryEvent(RefactoringHistoryService.this, eventType, proxy));
                }
            });
        }
    }

    private boolean checkDescriptor(RefactoringDescriptor descriptor, IUndoableOperation operation) {
        Assert.isNotNull((Object)descriptor);
        try {
            Map<String, String> arguments = RefactoringHistoryManager.getArgumentMap(descriptor);
            if (arguments != null) {
                RefactoringHistoryManager.checkArgumentMap(arguments);
            }
        }
        catch (CoreException exception) {
            IStatus status = exception.getStatus();
            if (status.getCode() == 10007) {
                String time = DateFormat.getDateTimeInstance().format(new Date(descriptor.getTimeStamp()));
                String message = "The refactoring executed at " + time + " contributed a refactoring descriptor with invalid format:";
                Status comment = new Status(4, RefactoringCorePlugin.getPluginId(), descriptor.getComment());
                RefactoringCorePlugin.log((IStatus)new MultiStatus(RefactoringCorePlugin.getPluginId(), 0, new IStatus[]{comment}, message, null));
            }
            RefactoringCorePlugin.log(exception);
            if (operation instanceof TriggeredOperations) {
                operation = ((TriggeredOperations)operation).getTriggeringOperation();
            }
            if (operation instanceof UndoableOperation2ChangeAdapter) {
                ((UndoableOperation2ChangeAdapter)operation).setChangeDescriptor(null);
            }
            return false;
        }
        return true;
    }

    @Override
    public RefactoringHistory getProjectHistory(IProject project, IProgressMonitor monitor) {
        return this.getProjectHistory(project, 0L, Long.MAX_VALUE, 0, monitor);
    }

    @Override
    public RefactoringHistory getProjectHistory(IProject project, long start, long end, int flags, IProgressMonitor monitor) {
        Assert.isNotNull((Object)project);
        Assert.isTrue((boolean)project.exists());
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= 0L ? 1 : 0) != 0);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (project.isOpen()) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 120);
                String name = project.getName();
                RefactoringHistoryManager manager = this.getManager(name);
                if (manager != null) {
                    RefactoringHistory history = manager.readRefactoringHistory(start, end, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    if (flags > 0) {
                        HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
                        RefactoringHistoryService.filterRefactoringDescriptors(history.getDescriptors(), set, false, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        history = new RefactoringHistoryImplementation(set.toArray(new RefactoringDescriptorProxy[set.size()]));
                    }
                    RefactoringHistory refactoringHistory = history;
                    return refactoringHistory;
                }
            }
            finally {
                monitor.done();
            }
        }
        return NO_HISTORY;
    }

    @Override
    public RefactoringHistory getRefactoringHistory(IProject[] projects, IProgressMonitor monitor) {
        return this.getRefactoringHistory(projects, 0L, Long.MAX_VALUE, 0, monitor);
    }

    @Override
    public RefactoringHistory getRefactoringHistory(IProject[] projects, long start, long end, int flags, IProgressMonitor monitor) {
        Assert.isNotNull((Object)projects);
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IProject project;
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 3 * projects.length);
            HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
            if (flags > 0) {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    project = iProjectArray[n2];
                    if (project.isAccessible()) {
                        RefactoringDescriptorProxy[] proxies = this.getProjectHistory(project, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 1)).getDescriptors();
                        RefactoringHistoryService.filterRefactoringDescriptors(proxies, set, false, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                    ++n2;
                }
            } else {
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n3 = 0;
                while (n3 < n) {
                    project = iProjectArray[n3];
                    if (project.isAccessible()) {
                        RefactoringDescriptorProxy[] proxies = this.getProjectHistory(project, start, end, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 3)).getDescriptors();
                        set.addAll(Arrays.asList(proxies));
                    }
                    ++n3;
                }
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[set.size()];
            set.toArray(proxies);
            RefactoringHistoryImplementation refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            return refactoringHistoryImplementation;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public RefactoringHistory getWorkspaceHistory(IProgressMonitor monitor) {
        return this.getWorkspaceHistory(0L, Long.MAX_VALUE, monitor);
    }

    @Override
    public RefactoringHistory getWorkspaceHistory(long start, long end, IProgressMonitor monitor) {
        return this.getRefactoringHistory(ResourcesPlugin.getWorkspace().getRoot().getProjects(), start, end, 0, monitor);
    }

    public RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream) throws CoreException {
        Assert.isNotNull((Object)stream);
        try {
            return RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, null, 0L, Long.MAX_VALUE);
        }
        catch (IOException exception) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
        }
    }

    @Override
    public RefactoringHistory readRefactoringHistory(InputStream stream, int flags) throws CoreException {
        Assert.isNotNull((Object)stream);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>();
        RefactoringSessionDescriptor descriptor = new RefactoringSessionReader(false, null).readSession(new InputSource(stream));
        if (descriptor != null) {
            RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
            if (flags > 0) {
                RefactoringDescriptor[] refactoringDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    RefactoringDescriptor d = refactoringDescriptorArray[n2];
                    int current = d.getFlags();
                    if ((current | flags) == current) {
                        list.add(d);
                    }
                    ++n2;
                }
            } else {
                list.addAll(Arrays.asList(descriptors));
            }
        }
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[list.size()];
        int index = 0;
        while (index < list.size()) {
            proxies[index] = new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)list.get(index));
            ++index;
        }
        return new RefactoringHistoryImplementation(proxies);
    }

    @Override
    public void removeExecutionListener(IRefactoringExecutionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fExecutionListeners.remove((Object)listener);
    }

    @Override
    public void removeHistoryListener(IRefactoringHistoryListener listener) {
        Assert.isNotNull((Object)listener);
        this.fHistoryListeners.remove((Object)listener);
    }

    public RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        Assert.isNotNull((Object)proxy);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            RefactoringHistoryManager manager = this.getManager(proxy.getProject());
            if (manager != null) {
                RefactoringDescriptor refactoringDescriptor = manager.requestDescriptor(proxy, monitor);
                return refactoringDescriptor;
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public void setOverrideTimeStamp(long stamp) {
        Assert.isTrue((stamp == -1L || stamp >= 0L ? 1 : 0) != 0);
        this.fOverrideTimeStamp = stamp;
    }

    @Override
    public void writeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, OutputStream stream, int flags, boolean time, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        Assert.isNotNull((Object)stream);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100 * proxies.length);
            this.connect();
            ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>(proxies.length);
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                int current;
                RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (descriptor != null && ((current = descriptor.getFlags()) | flags) == current) {
                    list.add(descriptor);
                }
                ++n2;
            }
            RefactoringDescriptor[] descriptors = new RefactoringDescriptor[list.size()];
            list.toArray(descriptors);
            RefactoringHistoryManager.writeRefactoringSession(stream, new RefactoringSessionDescriptor(descriptors, "1.0", null), time);
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public void writeRefactoringSession(RefactoringSessionDescriptor descriptor, OutputStream stream, boolean time) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        Assert.isNotNull((Object)stream);
        RefactoringHistoryManager.writeRefactoringSession(stream, descriptor, time);
    }

    private void moveHistory(IProject oldProject, IProject newProject, IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 60);
                IFileStore historyStore = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER);
                String oldName = oldProject.getName();
                String newName = newProject.getName();
                IFileStore oldStore = historyStore.getChild(oldName);
                if (oldStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                    IFileStore newStore = historyStore.getChild(newName);
                    if (newStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                        newStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2));
                    }
                    oldStore.move(newStore, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2));
                }
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void peformResourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        IResourceDelta delta;
        int type = event.getType();
        if ((type & 1) != 0 && (delta = event.getDelta()) != null && (deltas = delta.getAffectedChildren()).length == 2) {
            IPath toPath = deltas[0].getMovedToPath();
            IPath fromPath = deltas[1].getMovedFromPath();
            if (fromPath != null && toPath != null) {
                IResource oldResource = deltas[0].getResource();
                IResource newResource = deltas[1].getResource();
                if (oldResource.getType() == 4 && newResource.getType() == 4) {
                    this.moveHistory((IProject)oldResource, (IProject)newResource, (IProgressMonitor)new NullProgressMonitor());
                }
            } else if (deltas[0].getKind() == 1 && deltas[1].getKind() == 2) {
                IResource newResource = deltas[0].getResource();
                IResource oldResource = deltas[1].getResource();
                if (oldResource.getType() == 4 && newResource.getType() == 4) {
                    this.moveHistory((IProject)oldResource, (IProject)newResource, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    private RefactoringDescriptor getRefactoringDescriptor(IUndoableOperation operation) {
        ChangeDescriptor changeDescriptor;
        if (operation instanceof TriggeredOperations) {
            operation = ((TriggeredOperations)operation).getTriggeringOperation();
        }
        if (operation instanceof UndoableOperation2ChangeAdapter && (changeDescriptor = ((UndoableOperation2ChangeAdapter)operation).getChangeDescriptor()) instanceof RefactoringChangeDescriptor) {
            return ((RefactoringChangeDescriptor)changeDescriptor).getRefactoringDescriptor();
        }
        return null;
    }

    private void performHistoryNotification(OperationHistoryEvent event) {
        RefactoringDescriptor descriptor = this.getRefactoringDescriptor(event.getOperation());
        if (descriptor != null) {
            RefactoringDescriptorProxyAdapter proxy = new RefactoringDescriptorProxyAdapter(descriptor);
            switch (event.getEventType()) {
                case 1: {
                    if (!this.checkDescriptor(descriptor, event.getOperation())) break;
                    this.fireRefactoringExecutionEvent(proxy, 4);
                    break;
                }
                case 4: {
                    if (!"org.eclipse.ltk.core.refactoring.unknown".equals(descriptor.getID())) {
                        long timeStamp = this.fOverrideTimeStamp >= 0L ? this.fOverrideTimeStamp : System.currentTimeMillis();
                        descriptor.setTimeStamp(timeStamp);
                    }
                    this.fireRefactoringHistoryEvent(proxy, 1);
                    this.fireRefactoringExecutionEvent(proxy, 1);
                    break;
                }
                case 3: {
                    this.fireRefactoringExecutionEvent(proxy, 5);
                    break;
                }
                case 10: {
                    this.fireRefactoringHistoryEvent(proxy, 2);
                    this.fireRefactoringExecutionEvent(proxy, 2);
                    break;
                }
                case 2: {
                    this.fireRefactoringExecutionEvent(proxy, 6);
                    break;
                }
                case 9: {
                    this.fireRefactoringHistoryEvent(proxy, 1);
                    this.fireRefactoringExecutionEvent(proxy, 3);
                }
            }
        }
    }

    private RefactoringHistoryManager getManager(String name) {
        block6: {
            IFileStore store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER);
            if (name != null && !"".equals(name)) {
                try {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    if (!project.isAccessible()) break block6;
                    if (RefactoringHistoryService.hasSharedRefactoringHistory(project)) {
                        URI uri = project.getLocationURI();
                        if (uri != null) {
                            return this.getManager(EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER), name);
                        }
                        break block6;
                    }
                    return this.getManager(store.getChild(name), name);
                }
                catch (CoreException coreException) {}
            } else {
                return this.getManager(store.getChild(NAME_WORKSPACE_PROJECT), null);
            }
        }
        return null;
    }

    private RefactoringHistoryManager getManager(IFileStore store, String name) {
        Assert.isNotNull((Object)store);
        RefactoringHistoryManager manager = this.fManagerCache.get(store);
        if (manager == null) {
            manager = new RefactoringHistoryManager(store, name);
            this.fManagerCache.put(store, manager);
        }
        return manager;
    }

    private static final class NullRefactoringHistory
    extends RefactoringHistory {
        private static final RefactoringDescriptorProxy[] NO_PROXIES = new RefactoringDescriptorProxy[0];

        private NullRefactoringHistory() {
        }

        @Override
        public RefactoringDescriptorProxy[] getDescriptors() {
            return NO_PROXIES;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public RefactoringHistory removeAll(RefactoringHistory history) {
            return this;
        }
    }
}

