/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private Point imageSize = null;
    private CompositeImageDescriptor.CachedImageDataProvider baseImageData;
    private ImageDescriptor[] topLeft;
    private ImageDescriptor[] topRight;
    private ImageDescriptor[] bottomLeft;
    private ImageDescriptor[] bottomRight;

    public OverlayImageDescriptor(ImageDescriptor baseImage) {
        this.baseImageData = this.createCachedImageDataProvider(baseImage);
        this.imageSize = new Point(this.baseImageData.getWidth(), this.baseImageData.getHeight());
    }

    public void setTopLeft(ImageDescriptor[] topLeft) {
        this.topLeft = topLeft;
    }

    public void setTopRight(ImageDescriptor[] topRight) {
        this.topRight = topRight;
    }

    public void setBottomLeft(ImageDescriptor[] bottomLeft) {
        this.bottomLeft = bottomLeft;
    }

    public void setBottomRight(ImageDescriptor[] bottomRight) {
        this.bottomRight = bottomRight;
    }

    protected void drawCompositeImage(int width, int height) {
        CompositeImageDescriptor.CachedImageDataProvider base = this.baseImageData;
        this.drawImage((ImageDataProvider)base, 0, 0);
        if (this.topRight != null) {
            this.drawTopRight(this.topRight);
        }
        if (this.bottomRight != null) {
            this.drawBottomRight(this.bottomRight);
        }
        if (this.bottomLeft != null) {
            this.drawBottomLeft(this.bottomLeft);
        }
        if (this.topLeft != null) {
            this.drawTopLeft(this.topLeft);
        }
    }

    protected Point getSize() {
        return this.imageSize;
    }

    private void drawTopLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x, 0);
                x += idp.getWidth();
            }
            ++i;
        }
    }

    private void drawTopRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x -= idp.getWidth(), 0);
            }
            --i;
        }
    }

    private void drawBottomLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x, this.getSize().y - idp.getHeight());
                x += idp.getWidth();
            }
            ++i;
        }
    }

    private void drawBottomRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && overlays[i] != null) {
                CompositeImageDescriptor.CachedImageDataProvider idp = this.createCachedImageDataProvider(overlays[i]);
                this.drawImage((ImageDataProvider)idp, x -= idp.getWidth(), this.getSize().y - idp.getHeight());
            }
            --i;
        }
    }
}

