"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const util_1 = require("./util");
const constants_1 = require("./constants");
const { TouchBarButton } = electron_1.TouchBar;
const MAX_VISIBLE_LENGTH = 25;
function setTouchBar(items) {
    const touchBar = new electron_1.TouchBar({ items });
    const win = util_1.getWindow();
    win.setTouchBar(touchBar);
}
electron_1.ipcMain.on('conversations', (_event, conversations) => {
    const items = conversations.map(({ label, selected, icon }, index) => {
        return new TouchBarButton({
            label: label.length > MAX_VISIBLE_LENGTH ? label.slice(0, MAX_VISIBLE_LENGTH) + '…' : label,
            backgroundColor: selected ? '#0084ff' : undefined,
            icon: electron_1.nativeImage.createFromDataURL(icon),
            iconPosition: 'left',
            click: () => {
                util_1.sendAction('jump-to-conversation', index + 1);
            }
        });
    });
    setTouchBar(items);
});
electron_1.ipcMain.on('hide-touchbar-labels', (_event) => {
    const privateModeLabel = new TouchBarButton({
        label: 'Private mode enabled',
        backgroundColor: undefined,
        icon: electron_1.nativeImage.createFromPath(constants_1.caprineIconPath),
        iconPosition: 'left',
        click: undefined
    });
    setTouchBar([privateModeLabel]);
});
