/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.loc;

import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Exception;
import gps.GpsEvent;
import gps.log.GPSRecord;

public abstract class LocationSender
implements ModelListener {
    private int updatePeriod = 3600000;
    private Model model = null;
    private int next_update_time = 0;
    protected double latitude;
    protected double longitude;
    protected float speed;
    protected float heading;
    protected float altitude;
    protected int hdop;
    protected int nsat;
    protected String bluetoothAdress = "";

    public LocationSender(Model model) {
        this.model = model;
    }

    @Override
    public void modelEvent(ModelEvent object) {
        Object object2 = object;
        object = this;
        int n = ((GpsEvent)object2).getType();
        block1 : switch (n) {
            case 3: 
            case 4: {
                object2 = (GPSRecord)((GpsEvent)object2).getArg();
                ((LocationSender)object).latitude = ((GPSRecord)object2).latitude;
                ((LocationSender)object).longitude = ((GPSRecord)object2).longitude;
                switch (n) {
                    case 3: {
                        ((LocationSender)object).speed = ((GPSRecord)object2).speed;
                        ((LocationSender)object).heading = ((GPSRecord)object2).heading;
                        ((LocationSender)object).altitude = ((GPSRecord)object2).height;
                        break block1;
                    }
                    case 4: {
                        ((LocationSender)object).hdop = ((GPSRecord)object2).hdop / 100;
                        ((LocationSender)object).nsat = ((GPSRecord)object2).nsat / 256;
                    }
                }
            }
        }
        if (n == 3 || n == 4) {
            boolean bl;
            object = this;
            int n2 = JavaLibBridge.getTimeStamp();
            if (n2 >= ((LocationSender)object).next_update_time) {
                ((LocationSender)object).next_update_time = n2 + ((LocationSender)object).updatePeriod;
                bl = true;
            } else {
                bl = false;
            }
            if (bl) {
                try {
                    this.sendOutData();
                    return;
                }
                catch (BT747Exception bT747Exception) {
                    Generic.debug("Location sending", bT747Exception);
                }
            }
        }
    }

    protected abstract void sendOutData() throws BT747Exception;

    public final void setUpdatePeriod(int n) {
        this.updatePeriod = n;
    }

    public final void setBluetoothAdress(String string) {
        this.bluetoothAdress = string;
    }

    public final void notifyFatalFailure$552c4e01() {
        this.model.postEvent(new ModelEvent(274, this));
    }

    public final void notifyConnectionFailure$552c4e01() {
        this.model.postEvent(new ModelEvent(275, this));
    }

    public final void notifySuccess() {
        this.model.postEvent(new ModelEvent(276, this));
    }
}

