﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/AssetPropertyVariant.h>
#include <aws/iot/model/AssetPropertyTimestamp.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{

  /**
   * <p>An asset property value entry containing the following
   * information.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/AssetPropertyValue">AWS
   * API Reference</a></p>
   */
  class AWS_IOT_API AssetPropertyValue
  {
  public:
    AssetPropertyValue();
    AssetPropertyValue(Aws::Utils::Json::JsonView jsonValue);
    AssetPropertyValue& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The value of the asset property.</p>
     */
    inline const AssetPropertyVariant& GetValue() const{ return m_value; }

    /**
     * <p>The value of the asset property.</p>
     */
    inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }

    /**
     * <p>The value of the asset property.</p>
     */
    inline void SetValue(const AssetPropertyVariant& value) { m_valueHasBeenSet = true; m_value = value; }

    /**
     * <p>The value of the asset property.</p>
     */
    inline void SetValue(AssetPropertyVariant&& value) { m_valueHasBeenSet = true; m_value = std::move(value); }

    /**
     * <p>The value of the asset property.</p>
     */
    inline AssetPropertyValue& WithValue(const AssetPropertyVariant& value) { SetValue(value); return *this;}

    /**
     * <p>The value of the asset property.</p>
     */
    inline AssetPropertyValue& WithValue(AssetPropertyVariant&& value) { SetValue(std::move(value)); return *this;}


    /**
     * <p>The asset property value timestamp.</p>
     */
    inline const AssetPropertyTimestamp& GetTimestamp() const{ return m_timestamp; }

    /**
     * <p>The asset property value timestamp.</p>
     */
    inline bool TimestampHasBeenSet() const { return m_timestampHasBeenSet; }

    /**
     * <p>The asset property value timestamp.</p>
     */
    inline void SetTimestamp(const AssetPropertyTimestamp& value) { m_timestampHasBeenSet = true; m_timestamp = value; }

    /**
     * <p>The asset property value timestamp.</p>
     */
    inline void SetTimestamp(AssetPropertyTimestamp&& value) { m_timestampHasBeenSet = true; m_timestamp = std::move(value); }

    /**
     * <p>The asset property value timestamp.</p>
     */
    inline AssetPropertyValue& WithTimestamp(const AssetPropertyTimestamp& value) { SetTimestamp(value); return *this;}

    /**
     * <p>The asset property value timestamp.</p>
     */
    inline AssetPropertyValue& WithTimestamp(AssetPropertyTimestamp&& value) { SetTimestamp(std::move(value)); return *this;}


    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline const Aws::String& GetQuality() const{ return m_quality; }

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline bool QualityHasBeenSet() const { return m_qualityHasBeenSet; }

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline void SetQuality(const Aws::String& value) { m_qualityHasBeenSet = true; m_quality = value; }

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline void SetQuality(Aws::String&& value) { m_qualityHasBeenSet = true; m_quality = std::move(value); }

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline void SetQuality(const char* value) { m_qualityHasBeenSet = true; m_quality.assign(value); }

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline AssetPropertyValue& WithQuality(const Aws::String& value) { SetQuality(value); return *this;}

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline AssetPropertyValue& WithQuality(Aws::String&& value) { SetQuality(std::move(value)); return *this;}

    /**
     * <p>Optional. A string that describes the quality of the value. Accepts
     * substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or
     * <code>UNCERTAIN</code>.</p>
     */
    inline AssetPropertyValue& WithQuality(const char* value) { SetQuality(value); return *this;}

  private:

    AssetPropertyVariant m_value;
    bool m_valueHasBeenSet;

    AssetPropertyTimestamp m_timestamp;
    bool m_timestampHasBeenSet;

    Aws::String m_quality;
    bool m_qualityHasBeenSet;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
