(function() {
  var StartDotRegex, Token, _;

  _ = require('underscore-plus');

  StartDotRegex = /^\.?/;

  module.exports = Token = (function() {
    Token.prototype.value = null;

    Token.prototype.scopes = null;

    function Token(properties) {
      this.value = properties.value, this.scopes = properties.scopes;
    }

    Token.prototype.isEqual = function(other) {
      return this.value === other.value && _.isEqual(this.scopes, other.scopes);
    };

    Token.prototype.isBracket = function() {
      return /^meta\.brace\b/.test(_.last(this.scopes));
    };

    Token.prototype.matchesScopeSelector = function(selector) {
      var targetClasses;
      targetClasses = selector.replace(StartDotRegex, '').split('.');
      return _.any(this.scopes, function(scope) {
        var scopeClasses;
        scopeClasses = scope.split('.');
        return _.isSubset(targetClasses, scopeClasses);
      });
    };

    return Token;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
