(function() {
  var CompositeDisposable, Emitter, StylesElement, ref,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  ref = require('event-kit'), Emitter = ref.Emitter, CompositeDisposable = ref.CompositeDisposable;

  StylesElement = (function(superClass) {
    extend(StylesElement, superClass);

    function StylesElement() {
      return StylesElement.__super__.constructor.apply(this, arguments);
    }

    StylesElement.prototype.subscriptions = null;

    StylesElement.prototype.context = null;

    StylesElement.prototype.onDidAddStyleElement = function(callback) {
      return this.emitter.on('did-add-style-element', callback);
    };

    StylesElement.prototype.onDidRemoveStyleElement = function(callback) {
      return this.emitter.on('did-remove-style-element', callback);
    };

    StylesElement.prototype.onDidUpdateStyleElement = function(callback) {
      return this.emitter.on('did-update-style-element', callback);
    };

    StylesElement.prototype.createdCallback = function() {
      this.subscriptions = new CompositeDisposable;
      this.emitter = new Emitter;
      return this.styleElementClonesByOriginalElement = new WeakMap;
    };

    StylesElement.prototype.attachedCallback = function() {
      var ref1;
      return this.context = (ref1 = this.getAttribute('context')) != null ? ref1 : void 0;
    };

    StylesElement.prototype.detachedCallback = function() {
      this.subscriptions.dispose();
      return this.subscriptions = new CompositeDisposable;
    };

    StylesElement.prototype.attributeChangedCallback = function(attrName, oldVal, newVal) {
      if (attrName === 'context') {
        return this.contextChanged();
      }
    };

    StylesElement.prototype.initialize = function(styleManager) {
      this.styleManager = styleManager;
      if (this.styleManager == null) {
        throw new Error("Must pass a styleManager parameter when initializing a StylesElement");
      }
      this.subscriptions.add(this.styleManager.observeStyleElements(this.styleElementAdded.bind(this)));
      this.subscriptions.add(this.styleManager.onDidRemoveStyleElement(this.styleElementRemoved.bind(this)));
      return this.subscriptions.add(this.styleManager.onDidUpdateStyleElement(this.styleElementUpdated.bind(this)));
    };

    StylesElement.prototype.contextChanged = function() {
      var child, i, j, len, len1, ref1, ref2, styleElement;
      if (this.subscriptions == null) {
        return;
      }
      ref1 = Array.prototype.slice.call(this.children);
      for (i = 0, len = ref1.length; i < len; i++) {
        child = ref1[i];
        this.styleElementRemoved(child);
      }
      this.context = this.getAttribute('context');
      ref2 = this.styleManager.getStyleElements();
      for (j = 0, len1 = ref2.length; j < len1; j++) {
        styleElement = ref2[j];
        this.styleElementAdded(styleElement);
      }
    };

    StylesElement.prototype.styleElementAdded = function(styleElement) {
      var child, i, insertBefore, len, priority, ref1, styleElementClone;
      if (!this.styleElementMatchesContext(styleElement)) {
        return;
      }
      styleElementClone = styleElement.cloneNode(true);
      styleElementClone.sourcePath = styleElement.sourcePath;
      styleElementClone.context = styleElement.context;
      styleElementClone.priority = styleElement.priority;
      this.styleElementClonesByOriginalElement.set(styleElement, styleElementClone);
      priority = styleElement.priority;
      if (priority != null) {
        ref1 = this.children;
        for (i = 0, len = ref1.length; i < len; i++) {
          child = ref1[i];
          if (child.priority > priority) {
            insertBefore = child;
            break;
          }
        }
      }
      this.insertBefore(styleElementClone, insertBefore);
      return this.emitter.emit('did-add-style-element', styleElementClone);
    };

    StylesElement.prototype.styleElementRemoved = function(styleElement) {
      var ref1, styleElementClone;
      if (!this.styleElementMatchesContext(styleElement)) {
        return;
      }
      styleElementClone = (ref1 = this.styleElementClonesByOriginalElement.get(styleElement)) != null ? ref1 : styleElement;
      styleElementClone.remove();
      return this.emitter.emit('did-remove-style-element', styleElementClone);
    };

    StylesElement.prototype.styleElementUpdated = function(styleElement) {
      var styleElementClone;
      if (!this.styleElementMatchesContext(styleElement)) {
        return;
      }
      styleElementClone = this.styleElementClonesByOriginalElement.get(styleElement);
      styleElementClone.textContent = styleElement.textContent;
      return this.emitter.emit('did-update-style-element', styleElementClone);
    };

    StylesElement.prototype.styleElementMatchesContext = function(styleElement) {
      return (this.context == null) || styleElement.context === this.context;
    };

    return StylesElement;

  })(HTMLElement);

  module.exports = StylesElement = document.registerElement('atom-styles', {
    prototype: StylesElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
