(function() {
  var DefaultDirectoryProvider, Directory, fs, path, url;

  Directory = require('pathwatcher').Directory;

  fs = require('fs-plus');

  path = require('path');

  url = require('url');

  module.exports = DefaultDirectoryProvider = (function() {
    function DefaultDirectoryProvider() {}

    DefaultDirectoryProvider.prototype.directoryForURISync = function(uri) {
      var directory, directoryPath, host, normalizedPath;
      normalizedPath = this.normalizePath(uri);
      host = url.parse(uri).host;
      directoryPath = host ? uri : !fs.isDirectorySync(normalizedPath) && fs.isDirectorySync(path.dirname(normalizedPath)) ? path.dirname(normalizedPath) : normalizedPath;
      directory = new Directory(directoryPath);
      if (host) {
        directory.path = directoryPath;
        if (fs.isCaseInsensitive()) {
          directory.lowerCasePath = directoryPath.toLowerCase();
        }
      }
      return directory;
    };

    DefaultDirectoryProvider.prototype.directoryForURI = function(uri) {
      return Promise.resolve(this.directoryForURISync(uri));
    };

    DefaultDirectoryProvider.prototype.normalizePath = function(uri) {
      var matchData, pathWithNormalizedDiskDriveLetter;
      pathWithNormalizedDiskDriveLetter = process.platform === 'win32' && (matchData = uri.match(/^([a-z]):/)) ? "" + (matchData[1].toUpperCase()) + (uri.slice(1)) : uri;
      return path.normalize(pathWithNormalizedDiskDriveLetter);
    };

    return DefaultDirectoryProvider;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
