var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */
/* global beforeEach, afterEach, describe, it */

var _libWelcomePackage = require('../lib/welcome-package');

var _libWelcomePackage2 = _interopRequireDefault(_libWelcomePackage);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _helpers = require('./helpers');

describe('Welcome', function () {
  var welcomePackage = undefined;

  beforeEach(function () {
    welcomePackage = new _libWelcomePackage2['default']();
    atom.config.set('welcome.showOnStartup', true);
  });

  afterEach(function () {
    atom.reset();
  });

  describe("when `core.telemetryConsent` is 'undecided'", function () {
    beforeEach(_asyncToGenerator(function* () {
      atom.config.set('core.telemetryConsent', 'undecided');
      yield welcomePackage.activate();
    }));

    it('opens the telemetry consent pane and the welcome panes', function () {
      var panes = atom.workspace.getCenter().getPanes();
      _assert2['default'].equal(panes.length, 2);
      _assert2['default'].equal(panes[0].getItems()[0].getTitle(), 'Telemetry Consent');
      _assert2['default'].equal(panes[0].getItems()[1].getTitle(), 'Welcome');
      _assert2['default'].equal(panes[1].getItems()[0].getTitle(), 'Welcome Guide');
    });
  });

  describe('when `core.telemetryConsent` is not `undecided`', function () {
    beforeEach(_asyncToGenerator(function* () {
      atom.config.set('core.telemetryConsent', 'no');
      yield welcomePackage.activate();
    }));

    describe('when activated for the first time', function () {
      return it('shows the welcome panes', function () {
        var panes = atom.workspace.getCenter().getPanes();
        _assert2['default'].equal(panes.length, 2);
        _assert2['default'].equal(panes[0].getItems()[0].getTitle(), 'Welcome');
        _assert2['default'].equal(panes[1].getItems()[0].getTitle(), 'Welcome Guide');
      });
    });

    describe('the welcome:show command', function () {
      it('shows the welcome buffer', _asyncToGenerator(function* () {
        atom.workspace.getCenter().getPanes().map(function (pane) {
          return pane.destroy();
        });
        (0, _assert2['default'])(!atom.workspace.getActivePaneItem());

        var workspaceElement = atom.views.getView(atom.workspace);
        atom.commands.dispatch(workspaceElement, 'welcome:show');

        yield (0, _helpers.conditionPromise)(function () {
          return atom.workspace.getActivePaneItem();
        });

        var panes = atom.workspace.getCenter().getPanes();
        _assert2['default'].equal(panes.length, 2);
        _assert2['default'].equal(panes[0].getItems()[0].getTitle(), 'Welcome');
      }));
    });

    describe('deserializing the pane items', function () {
      describe('when GuideView is deserialized', function () {
        it('remembers open sections', function () {
          var panes = atom.workspace.getCenter().getPanes();
          var guideView = panes[1].getItems()[0];

          guideView.element.querySelector('details[data-section="snippets"]').setAttribute('open', 'open');
          guideView.element.querySelector('details[data-section="init-script"]').setAttribute('open', 'open');

          var state = guideView.serialize();

          _assert2['default'].deepEqual(state.openSections, ['init-script', 'snippets']);

          var newGuideView = welcomePackage.createGuideView(state);
          (0, _assert2['default'])(!newGuideView.element.querySelector('details[data-section="packages"]').hasAttribute('open'));
          (0, _assert2['default'])(newGuideView.element.querySelector('details[data-section="snippets"]').hasAttribute('open'));
          (0, _assert2['default'])(newGuideView.element.querySelector('details[data-section="init-script"]').hasAttribute('open'));
        });
      });
    });

    describe('reporting events', function () {
      var panes = undefined,
          guideView = undefined,
          reportedEvents = undefined;
      beforeEach(function () {
        panes = atom.workspace.getCenter().getPanes();
        guideView = panes[1].getItems()[0];
        reportedEvents = [];

        welcomePackage.reporterProxy.sendEvent = function () {
          for (var _len = arguments.length, event = Array(_len), _key = 0; _key < _len; _key++) {
            event[_key] = arguments[_key];
          }

          reportedEvents.push(event);
        };
      });

      describe('GuideView events', function () {
        it('captures expand and collapse events', function () {
          guideView.element.querySelector('details[data-section="packages"] summary').click();
          _assert2['default'].deepEqual(reportedEvents, [['expand-packages-section']]);

          guideView.element.querySelector('details[data-section="packages"]').setAttribute('open', 'open');
          guideView.element.querySelector('details[data-section="packages"] summary').click();
          _assert2['default'].deepEqual(reportedEvents, [['expand-packages-section'], ['collapse-packages-section']]);
        });

        it('captures button events', function () {
          for (var detailElement of Array.from(guideView.element.querySelector('details'))) {
            reportedEvents.length = 0;

            var sectionName = detailElement.dataset.section;
            var eventName = 'clicked-' + sectionName + '-cta';
            var primaryButton = detailElement.querySelector('.btn-primary');
            if (primaryButton) {
              primaryButton.click();
              _assert2['default'].deepEqual(reportedEvents, [[eventName]]);
            }
          }
        });
      });
    });

    describe('when the reporter changes', function () {
      return it('sends all queued events', function () {
        welcomePackage.reporterProxy.queue.length = 0;

        var reporter1 = {
          addCustomEvent: function addCustomEvent(category, event) {
            this.reportedEvents.push(_extends({ category: category }, event));
          },
          reportedEvents: []
        };
        var reporter2 = {
          addCustomEvent: function addCustomEvent(category, event) {
            this.reportedEvents.push(_extends({ category: category }, event));
          },
          reportedEvents: []
        };

        welcomePackage.reporterProxy.sendEvent('foo', 'bar', 10);
        welcomePackage.reporterProxy.sendEvent('foo2', 'bar2', 60);
        welcomePackage.reporterProxy.setReporter(reporter1);

        _assert2['default'].deepEqual(reporter1.reportedEvents, [{ category: 'welcome-v1', ea: 'foo', el: 'bar', ev: 10 }, { category: 'welcome-v1', ea: 'foo2', el: 'bar2', ev: 60 }]);

        welcomePackage.consumeReporter(reporter2);
        _assert2['default'].deepEqual(reporter2.reportedEvents, []);
      });
    });
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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