Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

/** @babel */

var _atom = require('atom');

var _ctags = require('ctags');

var _ctags2 = _interopRequireDefault(_ctags);

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var handlerPath = require.resolve('./load-tags-handler');

var wordAtCursor = function wordAtCursor(text, cursorIndex, wordSeparator, noStripBefore) {
  var beforeCursor = text.slice(0, cursorIndex);
  var afterCursor = text.slice(cursorIndex);
  var beforeCursorWordBegins = noStripBefore ? 0 : beforeCursor.lastIndexOf(wordSeparator) + 1;
  var afterCursorWordEnds = afterCursor.indexOf(wordSeparator);
  if (afterCursorWordEnds === -1) {
    afterCursorWordEnds = afterCursor.length;
  }
  return beforeCursor.slice(beforeCursorWordBegins) + afterCursor.slice(0, afterCursorWordEnds);
};

exports['default'] = {
  find: function find(editor, callback) {
    var symbol = undefined;
    var symbols = [];

    if (symbol = editor.getSelectedText()) {
      symbols.push(symbol);
    }

    if (!symbols.length) {
      (function () {
        var nonWordCharacters = undefined;
        var cursor = editor.getLastCursor();
        var cursorPosition = cursor.getBufferPosition();
        var scope = cursor.getScopeDescriptor();
        var rubyScopes = scope.getScopesArray().filter(function (s) {
          return (/^source\.ruby($|\.)/.test(s)
          );
        });

        var wordRegExp = rubyScopes.length ? (nonWordCharacters = atom.config.get('editor.nonWordCharacters', { scope: scope }),
        // Allow special handling for fully-qualified ruby constants
        nonWordCharacters = nonWordCharacters.replace(/:/g, ''), new RegExp('[^\\s' + _underscorePlus2['default'].escapeRegExp(nonWordCharacters) + ']+([!?]|\\s*=>?)?|[<=>]+', 'g')) : cursor.wordRegExp();

        var addSymbol = function addSymbol(symbol) {
          if (rubyScopes.length) {
            // Normalize assignment syntax
            if (/\s+=?$/.test(symbol)) {
              symbols.push(symbol.replace(/\s+=$/, '='));
            }
            // Strip away assignment & hashrocket syntax
            symbols.push(symbol.replace(/\s+=>?$/, ''));
          } else {
            symbols.push(symbol);
          }
        };

        // Can't use `getCurrentWordBufferRange` here because we want to select
        // the last match of the potential 2 matches under cursor.
        editor.scanInBufferRange(wordRegExp, cursor.getCurrentLineBufferRange(), function (_ref) {
          var range = _ref.range;
          var match = _ref.match;

          if (range.containsPoint(cursorPosition)) {
            symbol = match[0];
            if (rubyScopes.length && symbol.indexOf(':') > -1) {
              var cursorWithinSymbol = cursorPosition.column - range.start.column;
              // Add fully-qualified ruby constant up until the cursor position
              addSymbol(wordAtCursor(symbol, cursorWithinSymbol, ':', true));
              // Additionally, also look up the bare word under cursor
              addSymbol(wordAtCursor(symbol, cursorWithinSymbol, ':'));
            } else {
              addSymbol(symbol);
            }
          }
        });
      })();
    }

    if (!symbols.length) {
      process.nextTick(function () {
        callback(null, []);
      });
    }

    _async2['default'].map(atom.project.getPaths(), function (projectPath, done) {
      var tagsFile = (0, _getTagsFile2['default'])(projectPath);
      var foundTags = [];
      var foundErr = null;
      var detectCallback = function detectCallback() {
        done(foundErr, foundTags);
      };
      if (!tagsFile) {
        return detectCallback();
      }
      // Find the first symbol in the list that matches a tag
      return _async2['default'].detectSeries(symbols, function (symbol, doneDetect) {
        _ctags2['default'].findTags(tagsFile, symbol, function (err, tags) {
          if (!tags) {
            tags = [];
          }
          if (err) {
            foundErr = err;
            doneDetect(false);
          } else if (tags.length) {
            for (var tag of Array.from(tags)) {
              tag.directory = projectPath;
            }
            foundTags = tags;
            doneDetect(true);
          } else {
            doneDetect(false);
          }
        });
      }, detectCallback);
    }, function (err, foundTags) {
      callback(err, _underscorePlus2['default'].flatten(foundTags));
    });
  },

  getAllTags: function getAllTags(callback) {
    var projectTags = [];
    var task = _atom.Task.once(handlerPath, atom.project.getPaths(), function () {
      return callback(projectTags);
    });
    task.on('tags', function (tags) {
      projectTags.push.apply(projectTags, _toConsumableArray(tags));
    });
    return task;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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