Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var TagGenerator = (function () {
  function TagGenerator(path1, scopeName) {
    _classCallCheck(this, TagGenerator);

    this.path = path1;
    this.scopeName = scopeName;
  }

  _createClass(TagGenerator, [{
    key: 'getPackageRoot',
    value: function getPackageRoot() {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      var currentFileWasRequiredFromSnapshot = !_fsPlus2['default'].isAbsolute(__dirname);
      var packageRoot = currentFileWasRequiredFromSnapshot ? _path2['default'].join(resourcePath, 'node_modules', 'symbols-view') : _path2['default'].resolve(__dirname, '..');

      if (_path2['default'].extname(resourcePath) === '.asar' && packageRoot.indexOf(resourcePath) === 0) {
        return _path2['default'].join(resourcePath + '.unpacked', 'node_modules', 'symbols-view');
      } else {
        return packageRoot;
      }
    }
  }, {
    key: 'parseTagLine',
    value: function parseTagLine(line) {
      var sections = line.split('\t');
      if (sections.length > 3) {
        return {
          position: new _atom.Point(parseInt(sections[2], 10) - 1),
          name: sections[0]
        };
      }
      return null;
    }
  }, {
    key: 'getLanguage',
    value: function getLanguage() {
      if (['.cson', '.gyp'].includes(_path2['default'].extname(this.path))) {
        return 'Cson';
      }

      switch (this.scopeName) {
        case 'source.c':
          return 'C';
        case 'source.cpp':
          return 'C++';
        case 'source.clojure':
          return 'Lisp';
        case 'source.capnp':
          return 'Capnp';
        case 'source.cfscript':
          return 'ColdFusion';
        case 'source.cfscript.embedded':
          return 'ColdFusion';
        case 'source.coffee':
          return 'CoffeeScript';
        case 'source.css':
          return 'Css';
        case 'source.css.less':
          return 'Css';
        case 'source.css.scss':
          return 'Css';
        case 'source.elixir':
          return 'Elixir';
        case 'source.fountain':
          return 'Fountain';
        case 'source.gfm':
          return 'Markdown';
        case 'source.go':
          return 'Go';
        case 'source.java':
          return 'Java';
        case 'source.js':
          return 'JavaScript';
        case 'source.js.jsx':
          return 'JavaScript';
        case 'source.jsx':
          return 'JavaScript';
        case 'source.json':
          return 'Json';
        case 'source.julia':
          return 'Julia';
        case 'source.makefile':
          return 'Make';
        case 'source.objc':
          return 'C';
        case 'source.objcpp':
          return 'C++';
        case 'source.python':
          return 'Python';
        case 'source.ruby':
          return 'Ruby';
        case 'source.sass':
          return 'Sass';
        case 'source.yaml':
          return 'Yaml';
        case 'text.html':
          return 'Html';
        case 'text.html.php':
          return 'Php';
        case 'text.tex.latex':
          return 'Latex';
        case 'text.html.cfml':
          return 'ColdFusion';
      }
      return undefined;
    }
  }, {
    key: 'generate',
    value: function generate() {
      var _this = this;

      var tags = {};
      var packageRoot = this.getPackageRoot();
      var command = 'ctags';
      var defaultCtagsFile = _path2['default'].join(packageRoot, 'lib', 'ctags-config');
      var args = ['--options=' + defaultCtagsFile, '--fields=+KS'];

      if (atom.config.get('symbols-view.useEditorGrammarAsCtagsLanguage')) {
        var language = this.getLanguage();
        if (language) {
          args.push('--language-force=' + language);
        }
      }

      args.push('-nf', '-', this.path);

      return new Promise(function (resolve) {
        var result = undefined,
            tag = undefined;
        return new _atom.BufferedProcess({
          command: command,
          args: args,
          stdout: function stdout(lines) {
            return (function () {
              result = [];
              for (var line of Array.from(lines.split('\n'))) {
                var item = undefined;
                if (tag = _this.parseTagLine(line)) {
                  item = tags[tag.position.row] ? tags[tag.position.row] : tags[tag.position.row] = tag;
                }
                result.push(item);
              }
              return result;
            })();
          },
          stderr: function stderr() {},
          exit: function exit() {
            tags = (function () {
              result = [];
              for (var row in tags) {
                tag = tags[row];
                result.push(tag);
              }
              return result;
            })();
            return resolve(tags);
          }
        });
      });
    }
  }]);

  return TagGenerator;
})();

exports['default'] = TagGenerator;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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