Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _fuzzaldrin = require('fuzzaldrin');

var SymbolsView = (function () {
  _createClass(SymbolsView, null, [{
    key: 'highlightMatches',
    value: function highlightMatches(context, name, matches, offsetIndex) {
      if (!offsetIndex) {
        offsetIndex = 0;
      }
      var lastIndex = 0;
      var matchedChars = []; // Build up a set of matched chars to be more semantic
      var fragment = document.createDocumentFragment();

      for (var matchIndex of Array.from(matches)) {
        matchIndex -= offsetIndex;
        if (matchIndex < 0) {
          continue; // If marking up the basename, omit name matches
        }
        var unmatched = name.substring(lastIndex, matchIndex);
        if (unmatched) {
          if (matchedChars.length) {
            var span = document.createElement('span');
            span.classList.add('character-match');
            span.textContent = matchedChars.join('');
            fragment.appendChild(span);
          }
          matchedChars = [];
          fragment.appendChild(document.createTextNode(unmatched));
        }
        matchedChars.push(name[matchIndex]);
        lastIndex = matchIndex + 1;
      }

      if (matchedChars.length) {
        var span = document.createElement('span');
        span.classList.add('character-match');
        span.textContent = matchedChars.join('');
        fragment.appendChild(span);
      }

      // Remaining characters are plain text
      fragment.appendChild(document.createTextNode(name.substring(lastIndex)));

      return fragment;
    }
  }]);

  function SymbolsView(stack) {
    var emptyMessage = arguments.length <= 1 || arguments[1] === undefined ? 'No symbols found' : arguments[1];
    var maxResults = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

    _classCallCheck(this, SymbolsView);

    this.stack = stack;
    this.selectListView = new _atomSelectList2['default']({
      maxResults: maxResults,
      emptyMessage: emptyMessage,
      items: [],
      filterKeyForItem: function filterKeyForItem(item) {
        return item.name;
      },
      elementForItem: this.elementForItem.bind(this),
      didChangeSelection: this.didChangeSelection.bind(this),
      didConfirmSelection: this.didConfirmSelection.bind(this),
      didConfirmEmptySelection: this.didConfirmEmptySelection.bind(this),
      didCancelSelection: this.didCancelSelection.bind(this)
    });
    this.element = this.selectListView.element;
    this.element.classList.add('symbols-view');
    this.panel = atom.workspace.addModalPanel({ item: this, visible: false });
  }

  _createClass(SymbolsView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.cancel();
      this.panel.destroy();
      return this.selectListView.destroy();
    })
  }, {
    key: 'getFilterKey',
    value: function getFilterKey() {
      return 'name';
    }
  }, {
    key: 'elementForItem',
    value: function elementForItem(_ref) {
      var position = _ref.position;
      var name = _ref.name;
      var file = _ref.file;
      var directory = _ref.directory;

      // Style matched characters in search results
      var matches = (0, _fuzzaldrin.match)(name, this.selectListView.getFilterQuery());

      if (atom.project.getPaths().length > 1) {
        file = _path2['default'].join(_path2['default'].basename(directory), file);
      }

      var li = document.createElement('li');
      li.classList.add('two-lines');

      var primaryLine = document.createElement('div');
      primaryLine.classList.add('primary-line');
      if (position) {
        primaryLine.textContent = name + ':' + (position.row + 1);
      } else {
        primaryLine.appendChild(SymbolsView.highlightMatches(this, name, matches));
      }
      li.appendChild(primaryLine);

      var secondaryLine = document.createElement('div');
      secondaryLine.classList.add('secondary-line');
      secondaryLine.textContent = file;
      li.appendChild(secondaryLine);

      return li;
    }
  }, {
    key: 'cancel',
    value: _asyncToGenerator(function* () {
      if (!this.isCanceling) {
        this.isCanceling = true;
        yield this.selectListView.update({ items: [] });
        this.panel.hide();
        if (this.previouslyFocusedElement) {
          this.previouslyFocusedElement.focus();
          this.previouslyFocusedElement = null;
        }
        this.isCanceling = false;
      }
    })
  }, {
    key: 'didCancelSelection',
    value: function didCancelSelection() {
      this.cancel();
    }
  }, {
    key: 'didConfirmEmptySelection',
    value: function didConfirmEmptySelection() {
      this.cancel();
    }
  }, {
    key: 'didConfirmSelection',
    value: _asyncToGenerator(function* (tag) {
      var _this = this;

      if (tag.file && !_fsPlus2['default'].isFileSync(_path2['default'].join(tag.directory, tag.file))) {
        yield this.selectListView.update({ errorMessage: 'Selected file does not exist' });
        setTimeout(function () {
          _this.selectListView.update({ errorMessage: null });
        }, 2000);
      } else {
        yield this.cancel();
        this.openTag(tag);
      }
    })
  }, {
    key: 'didChangeSelection',
    value: function didChangeSelection(tag) {
      // no-op
    }
  }, {
    key: 'openTag',
    value: function openTag(tag) {
      var _this2 = this;

      var editor = atom.workspace.getActiveTextEditor();
      var previous = undefined;
      if (editor) {
        previous = {
          editorId: editor.id,
          position: editor.getCursorBufferPosition(),
          file: editor.getURI()
        };
      }

      var position = tag.position;

      if (!position) {
        position = this.getTagLine(tag);
      }
      if (tag.file) {
        atom.workspace.open(_path2['default'].join(tag.directory, tag.file)).then(function () {
          if (position) {
            return _this2.moveToPosition(position);
          }
          return undefined;
        });
      } else if (position && previous && !previous.position.isEqual(position)) {
        this.moveToPosition(position);
      }

      this.stack.push(previous);
    }
  }, {
    key: 'moveToPosition',
    value: function moveToPosition(position, beginningOfLine) {
      var editor = atom.workspace.getActiveTextEditor();
      if (beginningOfLine == null) {
        beginningOfLine = true;
      }
      if (editor) {
        editor.setCursorBufferPosition(position, { autoscroll: false });
        if (beginningOfLine) {
          editor.moveToFirstCharacterOfLine();
        }
        editor.scrollToCursorPosition({ center: true });
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.reset();
      this.selectListView.focus();
    }
  }, {
    key: 'getTagLine',
    value: function getTagLine(tag) {
      if (!tag) {
        return undefined;
      }

      if (tag.lineNumber) {
        return new _atom.Point(tag.lineNumber - 1, 0);
      }

      // Remove leading /^ and trailing $/
      if (!tag.pattern) {
        return undefined;
      }
      var pattern = tag.pattern.replace(/(^\/\^)|(\$\/$)/g, '').trim();

      if (!pattern) {
        return undefined;
      }
      var file = _path2['default'].join(tag.directory, tag.file);
      if (!_fsPlus2['default'].isFileSync(file)) {
        return undefined;
      }
      var iterable = _fsPlus2['default'].readFileSync(file, 'utf8').split('\n');
      for (var index = 0; index < iterable.length; index++) {
        var line = iterable[index];
        if (pattern === line.trim()) {
          return new _atom.Point(index, 0);
        }
      }

      return undefined;
    }
  }]);

  return SymbolsView;
})();

exports['default'] = SymbolsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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