Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */
/* global emit*/

var _async = require('async');

var _async2 = _interopRequireDefault(_async);

var _ctags = require('ctags');

var _ctags2 = _interopRequireDefault(_ctags);

var _getTagsFile = require('./get-tags-file');

var _getTagsFile2 = _interopRequireDefault(_getTagsFile);

exports['default'] = function (directoryPaths) {
  return _async2['default'].each(directoryPaths, function (directoryPath, done) {
    var tagsFilePath = (0, _getTagsFile2['default'])(directoryPath);
    if (!tagsFilePath) {
      return done();
    }

    var stream = _ctags2['default'].createReadStream(tagsFilePath);
    stream.on('data', function (tags) {
      for (var tag of Array.from(tags)) {
        tag.directory = directoryPath;
      }
      return emit('tags', tags);
    });
    stream.on('end', done);
    return stream.on('error', done);
  }, this.async());
};

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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