Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _roaster = require('roaster');

var _roaster2 = _interopRequireDefault(_roaster);

var _dompurify = require('dompurify');

var _dompurify2 = _interopRequireDefault(_dompurify);

function sanitize(html, readmeSrc) {
  var temporaryContainer = document.createElement('div');
  temporaryContainer.innerHTML = html;

  for (var checkbox of temporaryContainer.querySelectorAll('input[type="checkbox"]')) {
    checkbox.setAttribute('disabled', '');
  }

  var path = require('path');

  for (var image of temporaryContainer.querySelectorAll('img')) {
    var imageSrc = image.getAttribute('src');

    var changeImageSrc = true;

    // If src contains a protocol then it must be absolute
    if (/^(?:[a-z]+:)?\/\//i.test(imageSrc)) {
      changeImageSrc = false;
    }

    // If src contains a base64 encoded image it must be left unchanged
    if (/^data:image\/.*;base64/i.test(imageSrc)) {
      changeImageSrc = false;
    }

    // If path is absolute on file system it must be a local file, e.g. emoji
    if (path.isAbsolute(imageSrc)) {
      changeImageSrc = false;
    }

    // If imageSrc needs changing and readmeSrc isn't undefined (i.e. if package was unpublished)
    if (changeImageSrc && readmeSrc) {
      if (path.isAbsolute(readmeSrc)) {
        // If repoUrl is a local path (i.e. package is installed)
        image.setAttribute('src', path.join(readmeSrc, imageSrc));
      } else {
        // If repoUrl is a URL (i.e. package isn't installed)
        image.setAttribute('src', new URL(imageSrc, readmeSrc));
      }
    }
  }

  return (0, _dompurify2['default'])().sanitize(temporaryContainer.innerHTML);
}

// Displays the readme for a package, if it has one
// TODO Decide to keep this or current button-to-new-tab view

var PackageReadmeView = (function () {
  function PackageReadmeView(readme, readmeSrc) {
    var _this = this;

    _classCallCheck(this, PackageReadmeView);

    this.element = document.createElement('section');
    this.element.classList.add('section');

    var container = document.createElement('div');
    container.classList.add('section-container');

    var heading = document.createElement('div');
    heading.classList.add('section-heading', 'icon', 'icon-book');
    heading.textContent = 'README';
    container.appendChild(heading);

    this.packageReadme = document.createElement('div');
    this.packageReadme.classList.add('package-readme', 'native-key-bindings');
    this.packageReadme.tabIndex = -1;
    container.appendChild(this.packageReadme);
    this.element.appendChild(container);

    (0, _roaster2['default'])(readme || '### No README.', function (err, content) {
      if (err) {
        _this.packageReadme.innerHTML = '<h3>Error parsing README</h3>';
      } else {
        _this.packageReadme.innerHTML = sanitize(content, readmeSrc);
      }
    });
  }

  _createClass(PackageReadmeView, [{
    key: 'destroy',
    value: function destroy() {
      this.element.remove();
    }
  }]);

  return PackageReadmeView;
})();

exports['default'] = PackageReadmeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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