Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _electron = require('electron');

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _packageGrammarsView = require('./package-grammars-view');

var _packageGrammarsView2 = _interopRequireDefault(_packageGrammarsView);

var _packageKeymapView = require('./package-keymap-view');

var _packageKeymapView2 = _interopRequireDefault(_packageKeymapView);

var _packageReadmeView = require('./package-readme-view');

var _packageReadmeView2 = _interopRequireDefault(_packageReadmeView);

var _packageSnippetsView = require('./package-snippets-view');

var _packageSnippetsView2 = _interopRequireDefault(_packageSnippetsView);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var NORMALIZE_PACKAGE_DATA_README_ERROR = 'ERROR: No README data found!';

var PackageDetailView = (function () {
  function PackageDetailView(pack, settingsView, packageManager, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageDetailView);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);
    this.loadPackage();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    var packageRepoClickHandler = function packageRepoClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (typeof repoUrl === 'string') {
        if (_url2['default'].parse(repoUrl).pathname === '/atom/atom') {
          _electron.shell.openExternal(repoUrl + '/tree/master/packages/' + _this.pack.name);
        } else {
          _electron.shell.openExternal(repoUrl);
        }
      }
    };
    this.refs.packageRepo.addEventListener('click', packageRepoClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.packageRepo.removeEventListener('click', packageRepoClickHandler);
    }));

    var issueButtonClickHandler = function issueButtonClickHandler(event) {
      event.preventDefault();
      var bugUri = _this.packageManager.getRepositoryBugUri(_this.pack);
      if (bugUri) {
        _electron.shell.openExternal(bugUri);
      }
    };
    this.refs.issueButton.addEventListener('click', issueButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.issueButton.removeEventListener('click', issueButtonClickHandler);
    }));

    var changelogButtonClickHandler = function changelogButtonClickHandler(event) {
      event.preventDefault();
      if (_this.changelogPath) {
        _this.openMarkdownFile(_this.changelogPath);
      }
    };
    this.refs.changelogButton.addEventListener('click', changelogButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', changelogButtonClickHandler);
    }));

    var licenseButtonClickHandler = function licenseButtonClickHandler(event) {
      event.preventDefault();
      if (_this.licensePath) {
        _this.openMarkdownFile(_this.licensePath);
      }
    };
    this.refs.licenseButton.addEventListener('click', licenseButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.licenseButton.removeEventListener('click', licenseButtonClickHandler);
    }));

    var openButtonClickHandler = function openButtonClickHandler(event) {
      event.preventDefault();
      if (_fsPlus2['default'].existsSync(_this.pack.path)) {
        atom.open({ pathsToOpen: [_this.pack.path] });
      }
    };
    this.refs.openButton.addEventListener('click', openButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.openButton.removeEventListener('click', openButtonClickHandler);
    }));

    var learnMoreButtonClickHandler = function learnMoreButtonClickHandler(event) {
      event.preventDefault();
      _electron.shell.openExternal('https://atom.io/packages/' + _this.pack.name);
    };
    this.refs.learnMoreButton.addEventListener('click', learnMoreButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.learnMoreButton.removeEventListener('click', learnMoreButtonClickHandler);
    }));

    var breadcrumbClickHandler = function breadcrumbClickHandler(event) {
      event.preventDefault();
      _this.settingsView.showPanel(_this.breadcrumbBackPanel);
    };
    this.refs.breadcrumb.addEventListener('click', breadcrumbClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.breadcrumb.removeEventListener('click', breadcrumbClickHandler);
    }));
  }

  _createClass(PackageDetailView, [{
    key: 'completeInitialization',
    value: function completeInitialization() {
      if (this.refs.packageCard) {
        this.packageCard = this.refs.packageCard.packageCard;
      } else if (!this.packageCard) {
        // Had to load this from the network
        this.packageCard = new _packageCard2['default'](this.pack.metadata, this.settingsView, this.packageManager, { onSettingsView: true });
        this.refs.packageCardParent.replaceChild(this.packageCard.element, this.refs.loadingMessage);
      }

      this.refs.packageRepo.classList.remove('hidden');
      this.refs.startupTime.classList.remove('hidden');
      this.refs.buttons.classList.remove('hidden');
      this.activateConfig();
      this.populate();
      this.updateFileButtons();
      this.subscribeToPackageManager();
      this.renderReadme();
    }
  }, {
    key: 'loadPackage',
    value: function loadPackage() {
      var loadedPackage = atom.packages.getLoadedPackage(this.pack.name);
      if (loadedPackage) {
        this.pack = loadedPackage;
        this.completeInitialization();
      } else {
        // If the package metadata in `@pack` isn't complete, hit the network.
        if (!this.pack.metadata || !this.pack.metadata.owner) {
          this.fetchPackage();
        } else {
          this.completeInitialization();
        }
      }
    }
  }, {
    key: 'fetchPackage',
    value: function fetchPackage() {
      var _this2 = this;

      this.showLoadingMessage();
      this.packageManager.getClient()['package'](this.pack.name, function (err, packageData) {
        if (err || !packageData || !packageData.name) {
          _this2.hideLoadingMessage();
          _this2.showErrorMessage();
        } else {
          _this2.pack = packageData;
          // TODO: this should match Package.loadMetadata from core, but this is
          // an acceptable hacky workaround
          _this2.pack.metadata = _underscorePlus2['default'].extend(_this2.pack.metadata != null ? _this2.pack.metadata : {}, _this2.pack);
          _this2.completeInitialization();
        }
      });
    }
  }, {
    key: 'showLoadingMessage',
    value: function showLoadingMessage() {
      this.refs.loadingMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideLoadingMessage',
    value: function hideLoadingMessage() {
      this.refs.loadingMessage.classList.add('hidden');
    }
  }, {
    key: 'showErrorMessage',
    value: function showErrorMessage() {
      this.refs.errorMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideErrorMessage',
    value: function hideErrorMessage() {
      this.refs.errorMessage.classList.add('hidden');
    }
  }, {
    key: 'activateConfig',
    value: function activateConfig() {
      // Package.activateConfig() is part of the Private package API and should not be used outside of core.
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        this.pack.activateConfig();
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      if (this.packageCard) {
        this.packageCard.destroy();
        this.packageCard = null;
      }

      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      if (opts.back == null) {
        opts.back = 'Install';
      }

      this.breadcrumbBackPanel = opts.back;
      this.refs.breadcrumb.textContent = this.breadcrumbBackPanel;
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var packageCardView = undefined;
      if (this.pack && this.pack.metadata && this.pack.metadata.owner) {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(PackageCardComponent, {
            ref: 'packageCard',
            settingsView: this.settingsView,
            packageManager: this.packageManager,
            metadata: this.pack.metadata,
            options: { onSettingsView: true } })
        );
      } else {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' },
            'Loading ' + this.pack.name + '…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'errorMessage', className: 'alert alert-danger icon icon-hourglass hidden' },
            'Failed to load ',
            this.pack.name,
            ' - try again later.'
          )
        );
      }
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'package-detail' },
        _etch2['default'].dom(
          'ol',
          { ref: 'breadcrumbContainer', className: 'native-key-bindings breadcrumb', tabIndex: '-1' },
          _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom('a', { ref: 'breadcrumb' })
          ),
          _etch2['default'].dom(
            'li',
            { className: 'active' },
            _etch2['default'].dom('a', { ref: 'title' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panels-item' },
          _etch2['default'].dom(
            'section',
            { className: 'section' },
            _etch2['default'].dom(
              'form',
              { className: 'section-container package-detail-view' },
              _etch2['default'].dom(
                'div',
                { className: 'container package-container' },
                packageCardView
              ),
              _etch2['default'].dom('p', { ref: 'packageRepo', className: 'link icon icon-repo repo-link hidden' }),
              _etch2['default'].dom('p', { ref: 'startupTime', className: 'text icon icon-dashboard hidden', tabIndex: '-1' }),
              _etch2['default'].dom(
                'div',
                { ref: 'buttons', className: 'btn-wrap-group hidden' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'learnMoreButton', className: 'btn btn-default icon icon-link' },
                  'View on Atom.io'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'issueButton', className: 'btn btn-default icon icon-bug' },
                  'Report Issue'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'changelogButton', className: 'btn btn-default icon icon-squirrel' },
                  'CHANGELOG'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'licenseButton', className: 'btn btn-default icon icon-law' },
                  'LICENSE'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'openButton', className: 'btn btn-default icon icon-link-external' },
                  'View Code'
                )
              ),
              _etch2['default'].dom('div', { ref: 'errors' })
            )
          ),
          _etch2['default'].dom('div', { ref: 'sections' })
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      this.refs.title.textContent = '' + _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(this.pack.name));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';

      var repoUrl = this.packageManager.getRepositoryUrl(this.pack);
      if (repoUrl) {
        var repoName = _url2['default'].parse(repoUrl).pathname;
        this.refs.packageRepo.textContent = repoName.substring(1);
        this.refs.packageRepo.style.display = '';
      } else {
        this.refs.packageRepo.style.display = 'none';
      }

      this.updateInstalledState();
    }
  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      this.updateFileButtons();
      this.activateConfig();
      this.refs.startupTime.style.display = 'none';

      if (atom.packages.isPackageLoaded(this.pack.name)) {
        if (!atom.packages.isPackageDisabled(this.pack.name)) {
          this.settingsPanel = new _settingsPanel2['default']({ namespace: this.pack.name, includeTitle: false });
          this.keymapView = new _packageKeymapView2['default'](this.pack);
          this.refs.sections.appendChild(this.settingsPanel.element);
          this.refs.sections.appendChild(this.keymapView.element);

          if (this.pack.path) {
            this.grammarsView = new _packageGrammarsView2['default'](this.pack.path);
            this.snippetsView = new _packageSnippetsView2['default'](this.pack, this.snippetsProvider);
            this.refs.sections.appendChild(this.grammarsView.element);
            this.refs.sections.appendChild(this.snippetsView.element);
          }

          this.refs.startupTime.innerHTML = 'This ' + this.type + ' added <span class=\'highlight\'>' + this.getStartupTime() + 'ms</span> to startup time.';
          this.refs.startupTime.style.display = '';
        }
      }

      var sourceIsAvailable = this.packageManager.isPackageInstalled(this.pack.name) && !atom.packages.isBundledPackage(this.pack.name);
      if (sourceIsAvailable) {
        this.refs.openButton.style.display = '';
      } else {
        this.refs.openButton.style.display = 'none';
      }

      this.renderReadme();
    }
  }, {
    key: 'renderReadme',
    value: function renderReadme() {
      var readme = undefined;
      if (this.pack.metadata.readme && this.pack.metadata.readme.trim() !== NORMALIZE_PACKAGE_DATA_README_ERROR) {
        readme = this.pack.metadata.readme;
      } else {
        readme = null;
      }

      if (this.readmePath && !readme) {
        readme = _fsPlus2['default'].readFileSync(this.readmePath, { encoding: 'utf8' });
      }

      var readmeSrc = undefined;

      if (this.pack.path) {
        // If package is installed, use installed path
        readmeSrc = this.pack.path;
      } else {
        // If package isn't installed, use url path
        var repoUrl = this.packageManager.getRepositoryUrl(this.pack);

        // Check if URL is undefined (i.e. package is unpublished)
        if (repoUrl) {
          readmeSrc = repoUrl + '/blob/master/';
        }
      }

      var readmeView = new _packageReadmeView2['default'](readme, readmeSrc);
      if (this.readmeView) {
        this.readmeView.element.parentElement.replaceChild(readmeView.element, this.readmeView.element);
        this.readmeView.destroy();
      } else {
        this.refs.sections.appendChild(readmeView.element);
      }
      this.readmeView = readmeView;
    }
  }, {
    key: 'subscribeToPackageManager',
    value: function subscribeToPackageManager() {
      var _this3 = this;

      this.disposables.add(this.packageManager.on('theme-installed package-installed', function (_ref) {
        var pack = _ref.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-uninstalled package-uninstalled', function (_ref2) {
        var pack = _ref2.pack;

        if (_this3.pack.name === pack.name) {
          return _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-updated package-updated', function (_ref3) {
        var pack = _ref3.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateFileButtons();
          _this3.populate();
        }
      }));
    }
  }, {
    key: 'openMarkdownFile',
    value: function openMarkdownFile(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        atom.workspace.open(encodeURI('markdown-preview://' + path));
      } else {
        atom.workspace.open(path);
      }
    }
  }, {
    key: 'updateFileButtons',
    value: function updateFileButtons() {
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;

      var packagePath = this.pack.path != null ? this.pack.path : atom.packages.resolvePackagePath(this.pack.name);
      for (var child of _fsPlus2['default'].listSync(packagePath)) {
        switch (_path2['default'].basename(child, _path2['default'].extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
            break;
        }

        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }

      if (this.changelogPath) {
        this.refs.changelogButton.style.display = '';
      } else {
        this.refs.changelogButton.style.display = 'none';
      }

      if (this.licensePath) {
        this.refs.licenseButton.style.display = '';
      } else {
        this.refs.licenseButton.style.display = 'none';
      }
    }
  }, {
    key: 'getStartupTime',
    value: function getStartupTime() {
      var loadTime = this.pack.loadTime != null ? this.pack.loadTime : 0;
      var activateTime = this.pack.activateTime != null ? this.pack.activateTime : 0;
      return loadTime + activateTime;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return PackageDetailView;
})();

exports['default'] = PackageDetailView;

var PackageCardComponent = (function () {
  function PackageCardComponent(props) {
    _classCallCheck(this, PackageCardComponent);

    this.packageCard = new _packageCard2['default'](props.metadata, props.settingsView, props.packageManager, props.options);
    this.element = this.packageCard.element;
  }

  _createClass(PackageCardComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return PackageCardComponent;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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