(function() {
  var archive, async, colors, optimist, path;

  path = require('path');

  async = require('async');

  colors = require('colors');

  optimist = require('optimist');

  archive = require('./ls-archive');

  module.exports = function() {
    var cli, files, queue;
    cli = optimist.usage("Usage: lsa [file ...]\n\nList the files and folders inside an archive file.\n\nSupports .zip, .tar, .tar.gz, and .tgz files.").describe('colors', 'Enable colored output')["default"]('colors', true).boolean('colors').describe('help', 'Show this message').alias('h', 'help').demand(1);
    if (cli.argv.help) {
      cli.showHelp();
      return;
    }
    if (!cli.argv.colors) {
      colors.setTheme({
        cyan: 'stripColors',
        red: 'stripColors'
      });
    }
    queue = async.queue(function(archivePath, callback) {
      return (function(archivePath) {
        return archive.list(archivePath, function(error, files) {
          var file, index, prefix, _i, _len;
          if (error != null) {
            console.error(("Error reading: " + archivePath).red);
          } else {
            console.log("" + archivePath.cyan + " (" + files.length + ")");
            for (index = _i = 0, _len = files.length; _i < _len; index = ++_i) {
              file = files[index];
              if (index === files.length - 1) {
                prefix = '\u2514\u2500\u2500 ';
              } else {
                prefix = '\u251C\u2500\u2500 ';
              }
              console.log("" + prefix + (file.getPath()));
            }
            console.log();
          }
          return callback();
        });
      })(archivePath);
    });
    files = cli.argv._;
    return files.forEach(function(file) {
      return queue.push(path.resolve(process.cwd(), file));
    });
  };

}).call(this);
