Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _statusBarItem = require('./status-bar-item');

var _statusBarItem2 = _interopRequireDefault(_statusBarItem);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var LineEndingRegExp = /\r\n|\n/g;

// the following regular expression is executed natively via the `substring` package,
// where `\A` corresponds to the beginning of the string.
// More info: https://github.com/atom/line-ending-selector/pull/56
// eslint-disable-next-line no-useless-escape
var LFRegExp = /(\A|[^\r])\n/g;
var CRLFRegExp = /\r\n/g;

var disposables = null;
var modalPanel = null;
var lineEndingListView = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.commands.add('atom-text-editor', {
    'line-ending-selector:show': function lineEndingSelectorShow(event) {
      if (!modalPanel) {
        lineEndingListView = new _atomSelectList2['default']({
          items: [{ name: 'LF', value: '\n' }, { name: 'CRLF', value: '\r\n' }],
          filterKeyForItem: function filterKeyForItem(lineEnding) {
            return lineEnding.name;
          },
          didConfirmSelection: function didConfirmSelection(lineEnding) {
            setLineEnding(atom.workspace.getActiveTextEditor(), lineEnding.value);
            modalPanel.hide();
          },
          didCancelSelection: function didCancelSelection() {
            modalPanel.hide();
          },
          elementForItem: function elementForItem(lineEnding) {
            var element = document.createElement('li');
            element.textContent = lineEnding.name;
            return element;
          }
        });
        modalPanel = atom.workspace.addModalPanel({
          item: lineEndingListView
        });
        disposables.add(new _atom.Disposable(function () {
          lineEndingListView.destroy();
          modalPanel.destroy();
          modalPanel = null;
        }));
      }

      lineEndingListView.reset();
      modalPanel.show();
      lineEndingListView.focus();
    },

    'line-ending-selector:convert-to-LF': function lineEndingSelectorConvertToLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\n');
    },

    'line-ending-selector:convert-to-CRLF': function lineEndingSelectorConvertToCRLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\r\n');
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var statusBarItem = new _statusBarItem2['default']();
  var currentBufferDisposable = null;
  var tooltipDisposable = null;

  var updateTile = _underscorePlus2['default'].debounce(function (buffer) {
    getLineEndings(buffer).then(function (lineEndings) {
      if (lineEndings.size === 0) {
        var defaultLineEnding = getDefaultLineEnding();
        buffer.setPreferredLineEnding(defaultLineEnding);
        lineEndings = new Set().add(defaultLineEnding);
      }
      statusBarItem.setLineEndings(lineEndings);
    });
  }, 0);

  disposables.add(atom.workspace.observeActiveTextEditor(function (editor) {
    if (currentBufferDisposable) currentBufferDisposable.dispose();

    if (editor && editor.getBuffer) {
      (function () {
        var buffer = editor.getBuffer();
        updateTile(buffer);
        currentBufferDisposable = buffer.onDidChange(function (_ref) {
          var oldText = _ref.oldText;
          var newText = _ref.newText;

          if (!statusBarItem.hasLineEnding('\n')) {
            if (newText.indexOf('\n') >= 0) {
              updateTile(buffer);
            }
          } else if (!statusBarItem.hasLineEnding('\r\n')) {
            if (newText.indexOf('\r\n') >= 0) {
              updateTile(buffer);
            }
          } else if (oldText.indexOf('\n')) {
            updateTile(buffer);
          }
        });
      })();
    } else {
      statusBarItem.setLineEndings(new Set());
      currentBufferDisposable = null;
    }

    if (tooltipDisposable) {
      disposables.remove(tooltipDisposable);
      tooltipDisposable.dispose();
    }
    tooltipDisposable = atom.tooltips.add(statusBarItem.element, {
      title: function title() {
        return 'File uses ' + statusBarItem.description() + ' line endings';
      }
    });
    disposables.add(tooltipDisposable);
  }));

  disposables.add(new _atom.Disposable(function () {
    if (currentBufferDisposable) currentBufferDisposable.dispose();
  }));

  statusBarItem.onClick(function () {
    var editor = atom.workspace.getActiveTextEditor();
    atom.commands.dispatch(atom.views.getView(editor), 'line-ending-selector:show');
  });

  var tile = statusBar.addRightTile({ item: statusBarItem, priority: 200 });
  disposables.add(new _atom.Disposable(function () {
    return tile.destroy();
  }));
}

function getDefaultLineEnding() {
  switch (atom.config.get('line-ending-selector.defaultLineEnding')) {
    case 'LF':
      return '\n';
    case 'CRLF':
      return '\r\n';
    case 'OS Default':
    default:
      return _helpers2['default'].getProcessPlatform() === 'win32' ? '\r\n' : '\n';
  }
}

function getLineEndings(buffer) {
  if (typeof buffer.find === 'function') {
    return Promise.all([buffer.find(LFRegExp), buffer.find(CRLFRegExp)]).then(function (_ref2) {
      var _ref22 = _slicedToArray(_ref2, 2);

      var hasLF = _ref22[0];
      var hasCRLF = _ref22[1];

      var result = new Set();
      if (hasLF) result.add('\n');
      if (hasCRLF) result.add('\r\n');
      return result;
    });
  } else {
    return new Promise(function (resolve) {
      var result = new Set();
      for (var i = 0; i < buffer.getLineCount() - 1; i++) {
        result.add(buffer.lineEndingForRow(i));
      }
      resolve(result);
    });
  }
}

function setLineEnding(item, lineEnding) {
  if (item && item.getBuffer) {
    var buffer = item.getBuffer();
    buffer.setPreferredLineEnding(lineEnding);
    buffer.setText(buffer.getText().replace(LineEndingRegExp, lineEnding));
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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