"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsFooterView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "logStartReviewClick", () => {
      (0, _reporterProxy.addEvent)('start-pr-review', {
        "package": 'github',
        component: this.constructor.name
      });
    });
  }

  render() {
    return _react["default"].createElement("footer", {
      className: "github-ReviewsFooterView-footer"
    }, _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-footerTitle"
    }, "Reviews"), _react["default"].createElement("span", {
      className: "github-ReviewsFooterView"
    }, _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-commentCount"
    }, "Resolved", ' ', _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-commentsResolved"
    }, this.props.commentsResolved), ' ', "of", ' ', _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-totalComments"
    }, this.props.totalComments), ' ', "comments"), _react["default"].createElement("progress", {
      className: "github-ReviewsFooterView-progessBar",
      value: this.props.commentsResolved,
      max: this.props.totalComments
    }, ' ', "comments", ' ')), _react["default"].createElement("button", {
      className: "github-ReviewsFooterView-openReviewsButton btn btn-primary",
      onClick: this.props.openReviews
    }, "See reviews"), _react["default"].createElement("a", {
      href: this.props.pullRequestURL,
      className: "github-ReviewsFooterView-reviewChangesButton btn",
      onClick: this.logStartReviewClick
    }, "Start a new review"));
  }

}

exports["default"] = ReviewsFooterView;

_defineProperty(ReviewsFooterView, "propTypes", {
  commentsResolved: _propTypes["default"].number.isRequired,
  totalComments: _propTypes["default"].number.isRequired,
  pullRequestURL: _propTypes["default"].string.isRequired,
  // Controller actions
  openReviews: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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