"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BarePrStatusesView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _prStatusContextView = _interopRequireDefault(require("./pr-status-context-view"));

var _checkSuiteView = _interopRequireDefault(require("./check-suite-view"));

var _checkSuitesAccumulator = _interopRequireDefault(require("../containers/accumulators/check-suites-accumulator"));

var _buildStatus = require("../models/build-status");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _periodicRefresher = _interopRequireDefault(require("../periodic-refresher"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePrStatusesView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "refresh", () => {
      this.props.relay.refetch({
        id: this.props.pullRequest.id
      }, null, () => this.emitter.emit('did-refetch'), {
        force: true
      });
    });

    _defineProperty(this, "renderWithChecks", result => {
      for (const err of result.errors) {
        // eslint-disable-next-line no-console
        console.error(err);
      }

      if (!this.getHeadCommit().status && result.suites.length === 0) {
        return null;
      }

      this.refresherOpts.interval = this.createIntervalCallback(result.suites);

      if (this.props.displayType === 'full') {
        return this.renderAsFull(result);
      } else {
        return this.renderAsCheck(result);
      }
    });

    _defineProperty(this, "onDidRefetch", cb => this.emitter.on('did-refetch', cb));

    this.emitter = new _eventKit.Emitter();
    this.refresherOpts = {
      interval: this.createIntervalCallback([]),
      getCurrentId: () => this.props.pullRequest.id,
      refresh: this.refresh,
      minimumIntervalPerId: this.constructor.MINIMUM_REFRESH_INTERVAL
    };
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher["default"](this.constructor, this.refresherOpts);
    this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  render() {
    const headCommit = this.getHeadCommit();
    return _react["default"].createElement(_checkSuitesAccumulator["default"], {
      onDidRefetch: this.onDidRefetch,
      commit: headCommit
    }, this.renderWithChecks);
  }

  renderAsCheck({
    runsBySuite
  }) {
    const summaryStatus = this.getSummaryBuildStatus(runsBySuite);
    return _react["default"].createElement(_octicon["default"], {
      icon: summaryStatus.icon,
      className: `github-PrStatuses--${summaryStatus.classSuffix}`
    });
  }

  renderAsFull({
    suites,
    runsBySuite
  }) {
    const status = this.getHeadCommit().status;
    const contexts = status ? status.contexts : [];
    const summaryStatus = this.getSummaryBuildStatus(runsBySuite);
    const detailStatuses = this.getDetailBuildStatuses(runsBySuite);
    return _react["default"].createElement("div", {
      className: "github-PrStatuses"
    }, _react["default"].createElement("div", {
      className: "github-PrStatuses-header"
    }, _react["default"].createElement("div", {
      className: "github-PrStatuses-donut-chart"
    }, this.renderDonutChart(detailStatuses)), _react["default"].createElement("div", {
      className: "github-PrStatuses-summary"
    }, this.summarySentence(summaryStatus, detailStatuses))), _react["default"].createElement("ul", {
      className: "github-PrStatuses-list"
    }, contexts.map(context => _react["default"].createElement(_prStatusContextView["default"], {
      key: context.id,
      context: context
    })), suites.map(suite => _react["default"].createElement(_checkSuiteView["default"], {
      key: suite.id,
      checkSuite: suite,
      checkRuns: runsBySuite.get(suite),
      switchToIssueish: this.props.switchToIssueish
    }))));
  }

  renderDonutChart(detailStatuses) {
    const counts = this.countsFromStatuses(detailStatuses);
    return _react["default"].createElement(_statusDonutChart["default"], counts);
  }

  summarySentence(summaryStatus, detailStatuses) {
    if (this.isAllSucceeded(summaryStatus)) {
      return 'All checks succeeded';
    } else if (this.isAllFailed(detailStatuses)) {
      return 'All checks failed';
    } else {
      const noun = detailStatuses.length === 1 ? 'check' : 'checks';
      const parts = [];
      const {
        pending,
        failure,
        success
      } = this.countsFromStatuses(detailStatuses);

      if (pending > 0) {
        parts.push(`${pending} pending`);
      }

      if (failure > 0) {
        parts.push(`${failure} failing`);
      }

      if (success > 0) {
        parts.push(`${success} successful`);
      }

      return (0, _helpers.toSentence)(parts) + ` ${noun}`;
    }
  }

  countsFromStatuses(statuses) {
    const counts = {
      pending: 0,
      failure: 0,
      success: 0,
      neutral: 0
    };

    for (const buildStatus of statuses) {
      const count = counts[buildStatus.classSuffix];
      /* istanbul ignore else */

      if (count !== undefined) {
        counts[buildStatus.classSuffix] = count + 1;
      }
    }

    return counts;
  }

  getHeadCommit() {
    return this.props.pullRequest.recentCommits.edges[0].node.commit;
  }

  getSummaryBuildStatus(runsBySuite) {
    const contextStatus = (0, _buildStatus.buildStatusFromStatusContext)(this.getHeadCommit().status || {});
    const checkRunStatuses = [];

    for (const [, runs] of runsBySuite) {
      for (const checkRun of runs) {
        checkRunStatuses.push((0, _buildStatus.buildStatusFromCheckResult)(checkRun));
      }
    }

    return (0, _buildStatus.combineBuildStatuses)(contextStatus, ...checkRunStatuses);
  }

  getDetailBuildStatuses(runsBySuite) {
    const headCommit = this.getHeadCommit();
    const statuses = [];

    if (headCommit.status) {
      for (const context of headCommit.status.contexts) {
        statuses.push((0, _buildStatus.buildStatusFromStatusContext)(context));
      }
    }

    for (const [, checkRuns] of runsBySuite) {
      for (const checkRun of checkRuns) {
        statuses.push((0, _buildStatus.buildStatusFromCheckResult)(checkRun));
      }
    }

    return statuses;
  }

  createIntervalCallback(suites) {
    return () => {
      const statuses = [(0, _buildStatus.buildStatusFromStatusContext)(this.getHeadCommit().status || {}), ...suites.map(_buildStatus.buildStatusFromCheckResult)];

      if (statuses.some(status => status.classSuffix === 'pending')) {
        return this.constructor.PENDING_REFRESH_TIMEOUT;
      } else {
        return this.constructor.COMPLETED_REFRESH_TIMEOUT;
      }
    };
  }

  isAllSucceeded(buildStatuses) {
    return buildStatuses.classSuffix === 'success';
  }

  isAllFailed(detailStatuses) {
    return detailStatuses.every(s => s.classSuffix === 'failure');
  }

}

exports.BarePrStatusesView = BarePrStatusesView;

_defineProperty(BarePrStatusesView, "propTypes", {
  // Relay
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }).isRequired,
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    recentCommits: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].shape({
      commit: _propTypes["default"].shape({
        status: _propTypes["default"].shape({
          state: _propTypes["default"].string.isRequired,
          contexts: _propTypes["default"].arrayOf(_propTypes["default"].shape({
            id: _propTypes["default"].string.isRequired
          }).isRequired).isRequired
        })
      }).isRequired
    }).isRequired).isRequired
  }).isRequired,
  // Control
  displayType: _propTypes["default"].oneOf(['check', 'full']),
  // Action
  switchToIssueish: _propTypes["default"].func.isRequired
});

_defineProperty(BarePrStatusesView, "defaultProps", {
  displayType: 'full'
});

_defineProperty(BarePrStatusesView, "lastRefreshPerPr", new Map());

_defineProperty(BarePrStatusesView, "COMPLETED_REFRESH_TIMEOUT", 3 * 60 * 1000);

_defineProperty(BarePrStatusesView, "PENDING_REFRESH_TIMEOUT", 30 * 1000);

_defineProperty(BarePrStatusesView, "MINIMUM_REFRESH_INTERVAL", 15 * 1000);

var _default = (0, _reactRelay.createRefetchContainer)(BarePrStatusesView, {
  pullRequest: function () {
    const node = require("./__generated__/prStatusesView_pullRequest.graphql");

    if (node.hash && node.hash !== "e21e2ef5e505a4a8e895bf13cb4202ab") {
      console.error("The definition of 'prStatusesView_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prStatusesView_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/prStatusesViewRefetchQuery.graphql");

  if (node.hash && node.hash !== "34c4cfc61df6413f34a5efa61768cd48") {
    console.error("The definition of 'prStatusesViewRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/prStatusesViewRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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