"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BarePrStatusContextView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _buildStatus = require("../models/build-status");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BarePrStatusContextView extends _react["default"].Component {
  render() {
    const {
      context,
      description,
      state,
      targetUrl
    } = this.props.context;
    const {
      icon,
      classSuffix
    } = (0, _buildStatus.buildStatusFromStatusContext)({
      state
    });
    return _react["default"].createElement("li", {
      className: "github-PrStatuses-list-item"
    }, _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon,
      className: `github-PrStatuses--${classSuffix}`
    })), _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-context"
    }, _react["default"].createElement("strong", null, context), " ", description), _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-details-link"
    }, _react["default"].createElement("a", {
      href: targetUrl
    }, "Details")));
  }

}

exports.BarePrStatusContextView = BarePrStatusContextView;

_defineProperty(BarePrStatusContextView, "propTypes", {
  context: _propTypes["default"].shape({
    context: _propTypes["default"].string.isRequired,
    description: _propTypes["default"].string,
    state: _propTypes["default"].string.isRequired,
    targetUrl: _propTypes["default"].string
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BarePrStatusContextView, {
  context: function () {
    const node = require("./__generated__/prStatusContextView_context.graphql");

    if (node.hash && node.hash !== "e729074e494e07b59b4a177416eb7a3c") {
      console.error("The definition of 'prStatusContextView_context' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prStatusContextView_context.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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