"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _modelObserver = _interopRequireDefault(require("../models/model-observer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObserveModel extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "fetchData", model => this.props.fetchData(model, ...this.props.fetchParams));

    _defineProperty(this, "didUpdate", () => {
      if (this.mounted) {
        const data = this.modelObserver.getActiveModelData();
        this.setState({
          data
        });
      }
    });

    this.state = {
      data: null
    };
    this.modelObserver = new _modelObserver["default"]({
      fetchData: this.fetchData,
      didUpdate: this.didUpdate
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentDidUpdate(prevProps) {
    this.modelObserver.setActiveModel(this.props.model);

    if (!this.modelObserver.hasPendingUpdate() && prevProps.fetchParams.length !== this.props.fetchParams.length || prevProps.fetchParams.some((prevParam, i) => prevParam !== this.props.fetchParams[i])) {
      this.modelObserver.refreshModelData();
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }

}

exports["default"] = ObserveModel;

_defineProperty(ObserveModel, "propTypes", {
  model: _propTypes["default"].shape({
    onDidUpdate: _propTypes["default"].func.isRequired
  }),
  fetchData: _propTypes["default"].func.isRequired,
  fetchParams: _propTypes["default"].arrayOf(_propTypes["default"].any),
  children: _propTypes["default"].func.isRequired
});

_defineProperty(ObserveModel, "defaultProps", {
  fetchParams: []
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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