"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _loadingView = _interopRequireDefault(require("./loading-view"));

var _remoteSelectorView = _interopRequireDefault(require("./remote-selector-view"));

var _remoteContainer = _interopRequireDefault(require("../containers/remote-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabView extends _react["default"].Component {
  render() {
    return _react["default"].createElement("div", {
      className: "github-GitHub",
      ref: this.props.rootHolder.setter
    }, _react["default"].createElement("div", {
      className: "github-GitHub-content"
    }, this.renderRemote()));
  }

  renderRemote() {
    if (this.props.isLoading) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    if (this.props.currentRemote.isPresent()) {
      // Single, chosen or unambiguous remote
      return _react["default"].createElement(_remoteContainer["default"], {
        loginModel: this.props.loginModel,
        endpoint: this.props.currentRemote.getEndpoint(),
        remoteOperationObserver: this.props.remoteOperationObserver,
        pushInProgress: this.props.pushInProgress,
        workingDirectory: this.props.workingDirectory,
        workspace: this.props.workspace,
        remote: this.props.currentRemote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount,
        onPushBranch: () => this.props.handlePushBranch(this.props.currentBranch, this.props.currentRemote)
      });
    }

    if (this.props.manyRemotesAvailable) {
      // No chosen remote, multiple remotes hosted on GitHub instances
      return _react["default"].createElement(_remoteSelectorView["default"], {
        remotes: this.props.remotes,
        currentBranch: this.props.currentBranch,
        selectRemote: this.props.handleRemoteSelect
      });
    } // No remotes available
    // TODO: display a view that lets you create a repository on GitHub


    return _react["default"].createElement("div", {
      className: "github-GitHub-noRemotes"
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mark-github"
    }), _react["default"].createElement("h1", null, "No Remotes"), _react["default"].createElement("div", {
      className: "initialize-repo-description"
    }, _react["default"].createElement("span", null, "This repository does not have any remotes hosted at GitHub.com.")));
  }

}

exports["default"] = GitHubTabView;

_defineProperty(GitHubTabView, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  currentRemote: _propTypes2.RemotePropType.isRequired,
  manyRemotesAvailable: _propTypes["default"].bool.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  handlePushBranch: _propTypes["default"].func.isRequired,
  handleRemoteSelect: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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