"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareEmojiReactionsView = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _classnames = _interopRequireDefault(require("classnames"));

var _reactionPickerController = _interopRequireDefault(require("../controllers/reaction-picker-controller"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareEmojiReactionsView extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.refAddButton = new _refHolder["default"]();
    this.refTooltip = new _refHolder["default"]();
  }

  render() {
    const viewerReacted = this.props.reactable.reactionGroups.filter(group => group.viewerHasReacted).map(group => group.content);
    const {
      reactionGroups
    } = this.props.reactable;
    const showAddButton = reactionGroups.length === 0 || reactionGroups.some(g => g.users.totalCount === 0);
    return _react["default"].createElement("div", {
      className: "github-EmojiReactions btn-toolbar"
    }, showAddButton && _react["default"].createElement("div", {
      className: "btn-group"
    }, _react["default"].createElement("button", {
      className: "github-EmojiReactions-add btn icon icon-smiley",
      ref: this.refAddButton.setter,
      disabled: !this.props.reactable.viewerCanReact
    }), _react["default"].createElement(_tooltip["default"], {
      manager: this.props.tooltips,
      target: this.refAddButton,
      trigger: "click",
      className: "github-Popover",
      refTooltip: this.refTooltip
    }, _react["default"].createElement(_reactionPickerController["default"], {
      viewerReacted: viewerReacted,
      addReaction: this.props.addReaction,
      removeReaction: this.props.removeReaction,
      tooltipHolder: this.refTooltip
    }))), _react["default"].createElement("div", {
      className: "btn-group"
    }, this.props.reactable.reactionGroups.map(group => {
      const emoji = _helpers.reactionTypeToEmoji[group.content];

      if (!emoji) {
        return null;
      }

      if (group.users.totalCount === 0) {
        return null;
      }

      const className = (0, _classnames["default"])('github-EmojiReactions-group', 'btn', group.content.toLowerCase(), {
        selected: group.viewerHasReacted
      });
      const toggle = !group.viewerHasReacted ? () => this.props.addReaction(group.content) : () => this.props.removeReaction(group.content);
      const disabled = !this.props.reactable.viewerCanReact;
      return _react["default"].createElement("button", {
        key: group.content,
        className: className,
        onClick: toggle,
        disabled: disabled
      }, _helpers.reactionTypeToEmoji[group.content], " \xA0 ", group.users.totalCount);
    })));
  }

}

exports.BareEmojiReactionsView = BareEmojiReactionsView;

_defineProperty(BareEmojiReactionsView, "propTypes", {
  // Relay response
  reactable: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    reactionGroups: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      content: _propTypes["default"].string.isRequired,
      viewerHasReacted: _propTypes["default"].bool.isRequired,
      users: _propTypes["default"].shape({
        totalCount: _propTypes["default"].number.isRequired
      }).isRequired
    })).isRequired,
    viewerCanReact: _propTypes["default"].bool.isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  addReaction: _propTypes["default"].func.isRequired,
  removeReaction: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareEmojiReactionsView, {
  reactable: function () {
    const node = require("./__generated__/emojiReactionsView_reactable.graphql");

    if (node.hash && node.hash !== "fde156007f42d841401632fce79875d5") {
      console.error("The definition of 'emojiReactionsView_reactable' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/emojiReactionsView_reactable.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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