"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _dialogView = _interopRequireDefault(require("./dialog-view"));

var _autofocus = _interopRequireDefault(require("../autofocus"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CredentialDialog extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "recaptureFocus", () => this.autofocus.trigger());

    _defineProperty(this, "accept", () => {
      if (!this.canSignIn()) {
        return Promise.resolve();
      }

      const request = this.props.request;
      const params = request.getParams();
      const payload = {
        password: this.state.password
      };

      if (params.includeUsername) {
        payload.username = this.state.username;
      }

      if (params.includeRemember) {
        payload.remember = this.state.remember;
      }

      return request.accept(payload);
    });

    _defineProperty(this, "didChangeUsername", e => this.setState({
      username: e.target.value
    }));

    _defineProperty(this, "didChangePassword", e => this.setState({
      password: e.target.value
    }));

    _defineProperty(this, "didChangeRemember", e => this.setState({
      remember: e.target.checked
    }));

    _defineProperty(this, "toggleShowPassword", () => this.setState({
      showPassword: !this.state.showPassword
    }));

    this.autofocus = new _autofocus["default"]();
    this.state = {
      username: '',
      password: '',
      remember: false,
      showPassword: false
    };
  }

  render() {
    const request = this.props.request;
    const params = request.getParams();
    return _react["default"].createElement(_dialogView["default"], {
      prompt: params.prompt,
      acceptEnabled: this.canSignIn(),
      acceptTabIndex: 5,
      acceptText: "Sign in",
      cancelTabIndex: 6,
      accept: this.accept,
      cancel: request.cancel,
      autofocus: this.autofocus,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, params.includeUsername && _react["default"].createElement("label", {
      className: "github-DialogLabel github-DialogLabel--horizontal"
    }, "Username:", _react["default"].createElement("input", {
      ref: this.autofocus.firstTarget(0),
      tabIndex: "1",
      type: "text",
      className: "input-text native-key-bindings github-Credential-username",
      value: this.state.username,
      onChange: this.didChangeUsername
    })), _react["default"].createElement("label", {
      className: "github-DialogLabel github-DialogLabel--horizontal"
    }, "Password:", _react["default"].createElement("input", {
      ref: this.autofocus.firstTarget(1),
      tabIndex: "2",
      type: this.state.showPassword ? 'text' : 'password',
      className: "input-text native-key-bindings github-Credential-password",
      value: this.state.password,
      onChange: this.didChangePassword
    }), _react["default"].createElement("button", {
      className: "github-Dialog--insetButton github-Credential-visibility",
      tabIndex: "3",
      onClick: this.toggleShowPassword
    }, this.state.showPassword ? 'Hide' : 'Show')), params.includeRemember && _react["default"].createElement("label", {
      className: "github-DialogLabel github-DialogLabel--horizontal github-Credential-rememberLabel"
    }, _react["default"].createElement("input", {
      tabIndex: "4",
      className: "input-checkbox github-Credential-remember",
      type: "checkbox",
      checked: this.state.remember,
      onChange: this.didChangeRemember
    }), "Remember"));
  }

  componentDidMount() {
    this.autofocus.trigger();
  }

  canSignIn() {
    return !this.props.request.getParams().includeUsername || this.state.username.length > 0;
  }

}

exports["default"] = CredentialDialog;

_defineProperty(CredentialDialog, "propTypes", {
  // Model
  request: _propTypes["default"].shape({
    getParams: _propTypes["default"].func.isRequired,
    accept: _propTypes["default"].func.isRequired,
    cancel: _propTypes["default"].func.isRequired
  }).isRequired,
  inProgress: _propTypes["default"].bool,
  error: _propTypes["default"].instanceOf(Error),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNyZWRlbnRpYWwtZGlhbG9nLmpzIl0sIm5hbWVzIjpbIkNyZWRlbnRpYWxEaWFsb2ciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJhdXRvZm9jdXMiLCJ0cmlnZ2VyIiwiY2FuU2lnbkluIiwiUHJvbWlzZSIsInJlc29sdmUiLCJyZXF1ZXN0IiwicGFyYW1zIiwiZ2V0UGFyYW1zIiwicGF5bG9hZCIsInBhc3N3b3JkIiwic3RhdGUiLCJpbmNsdWRlVXNlcm5hbWUiLCJ1c2VybmFtZSIsImluY2x1ZGVSZW1lbWJlciIsInJlbWVtYmVyIiwiYWNjZXB0IiwiZSIsInNldFN0YXRlIiwidGFyZ2V0IiwidmFsdWUiLCJjaGVja2VkIiwic2hvd1Bhc3N3b3JkIiwiQXV0b0ZvY3VzIiwicmVuZGVyIiwicHJvbXB0IiwiY2FuY2VsIiwiaW5Qcm9ncmVzcyIsImVycm9yIiwid29ya3NwYWNlIiwiY29tbWFuZHMiLCJmaXJzdFRhcmdldCIsImRpZENoYW5nZVVzZXJuYW1lIiwiZGlkQ2hhbmdlUGFzc3dvcmQiLCJ0b2dnbGVTaG93UGFzc3dvcmQiLCJkaWRDaGFuZ2VSZW1lbWJlciIsImNvbXBvbmVudERpZE1vdW50IiwibGVuZ3RoIiwiUHJvcFR5cGVzIiwic2hhcGUiLCJmdW5jIiwiaXNSZXF1aXJlZCIsImJvb2wiLCJpbnN0YW5jZU9mIiwiRXJyb3IiLCJvYmplY3QiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFFQTs7QUFDQTs7Ozs7O0FBRWUsTUFBTUEsZ0JBQU4sU0FBK0JDLGtCQUFNQyxTQUFyQyxDQUErQztBQWdCNURDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47O0FBRGlCLDRDQW1GRixNQUFNLEtBQUtDLFNBQUwsQ0FBZUMsT0FBZixFQW5GSjs7QUFBQSxvQ0FxRlYsTUFBTTtBQUNiLFVBQUksQ0FBQyxLQUFLQyxTQUFMLEVBQUwsRUFBdUI7QUFDckIsZUFBT0MsT0FBTyxDQUFDQyxPQUFSLEVBQVA7QUFDRDs7QUFFRCxZQUFNQyxPQUFPLEdBQUcsS0FBS04sS0FBTCxDQUFXTSxPQUEzQjtBQUNBLFlBQU1DLE1BQU0sR0FBR0QsT0FBTyxDQUFDRSxTQUFSLEVBQWY7QUFFQSxZQUFNQyxPQUFPLEdBQUc7QUFBQ0MsUUFBQUEsUUFBUSxFQUFFLEtBQUtDLEtBQUwsQ0FBV0Q7QUFBdEIsT0FBaEI7O0FBRUEsVUFBSUgsTUFBTSxDQUFDSyxlQUFYLEVBQTRCO0FBQzFCSCxRQUFBQSxPQUFPLENBQUNJLFFBQVIsR0FBbUIsS0FBS0YsS0FBTCxDQUFXRSxRQUE5QjtBQUNEOztBQUVELFVBQUlOLE1BQU0sQ0FBQ08sZUFBWCxFQUE0QjtBQUMxQkwsUUFBQUEsT0FBTyxDQUFDTSxRQUFSLEdBQW1CLEtBQUtKLEtBQUwsQ0FBV0ksUUFBOUI7QUFDRDs7QUFFRCxhQUFPVCxPQUFPLENBQUNVLE1BQVIsQ0FBZVAsT0FBZixDQUFQO0FBQ0QsS0F4R2tCOztBQUFBLCtDQTBHQ1EsQ0FBQyxJQUFJLEtBQUtDLFFBQUwsQ0FBYztBQUFDTCxNQUFBQSxRQUFRLEVBQUVJLENBQUMsQ0FBQ0UsTUFBRixDQUFTQztBQUFwQixLQUFkLENBMUdOOztBQUFBLCtDQTRHQ0gsQ0FBQyxJQUFJLEtBQUtDLFFBQUwsQ0FBYztBQUFDUixNQUFBQSxRQUFRLEVBQUVPLENBQUMsQ0FBQ0UsTUFBRixDQUFTQztBQUFwQixLQUFkLENBNUdOOztBQUFBLCtDQThHQ0gsQ0FBQyxJQUFJLEtBQUtDLFFBQUwsQ0FBYztBQUFDSCxNQUFBQSxRQUFRLEVBQUVFLENBQUMsQ0FBQ0UsTUFBRixDQUFTRTtBQUFwQixLQUFkLENBOUdOOztBQUFBLGdEQWdIRSxNQUFNLEtBQUtILFFBQUwsQ0FBYztBQUFDSSxNQUFBQSxZQUFZLEVBQUUsQ0FBQyxLQUFLWCxLQUFMLENBQVdXO0FBQTNCLEtBQWQsQ0FoSFI7O0FBR2pCLFNBQUtyQixTQUFMLEdBQWlCLElBQUlzQixxQkFBSixFQUFqQjtBQUVBLFNBQUtaLEtBQUwsR0FBYTtBQUNYRSxNQUFBQSxRQUFRLEVBQUUsRUFEQztBQUVYSCxNQUFBQSxRQUFRLEVBQUUsRUFGQztBQUdYSyxNQUFBQSxRQUFRLEVBQUUsS0FIQztBQUlYTyxNQUFBQSxZQUFZLEVBQUU7QUFKSCxLQUFiO0FBTUQ7O0FBRURFLEVBQUFBLE1BQU0sR0FBRztBQUNQLFVBQU1sQixPQUFPLEdBQUcsS0FBS04sS0FBTCxDQUFXTSxPQUEzQjtBQUNBLFVBQU1DLE1BQU0sR0FBR0QsT0FBTyxDQUFDRSxTQUFSLEVBQWY7QUFFQSxXQUNFLGdDQUFDLHNCQUFEO0FBQ0UsTUFBQSxNQUFNLEVBQUVELE1BQU0sQ0FBQ2tCLE1BRGpCO0FBRUUsTUFBQSxhQUFhLEVBQUUsS0FBS3RCLFNBQUwsRUFGakI7QUFHRSxNQUFBLGNBQWMsRUFBRSxDQUhsQjtBQUlFLE1BQUEsVUFBVSxFQUFDLFNBSmI7QUFLRSxNQUFBLGNBQWMsRUFBRSxDQUxsQjtBQU1FLE1BQUEsTUFBTSxFQUFFLEtBQUthLE1BTmY7QUFPRSxNQUFBLE1BQU0sRUFBRVYsT0FBTyxDQUFDb0IsTUFQbEI7QUFRRSxNQUFBLFNBQVMsRUFBRSxLQUFLekIsU0FSbEI7QUFTRSxNQUFBLFVBQVUsRUFBRSxLQUFLRCxLQUFMLENBQVcyQixVQVR6QjtBQVVFLE1BQUEsS0FBSyxFQUFFLEtBQUszQixLQUFMLENBQVc0QixLQVZwQjtBQVdFLE1BQUEsU0FBUyxFQUFFLEtBQUs1QixLQUFMLENBQVc2QixTQVh4QjtBQVlFLE1BQUEsUUFBUSxFQUFFLEtBQUs3QixLQUFMLENBQVc4QjtBQVp2QixPQWNHdkIsTUFBTSxDQUFDSyxlQUFQLElBQ0M7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQixvQkFFRTtBQUNFLE1BQUEsR0FBRyxFQUFFLEtBQUtYLFNBQUwsQ0FBZThCLFdBQWYsQ0FBMkIsQ0FBM0IsQ0FEUDtBQUVFLE1BQUEsUUFBUSxFQUFDLEdBRlg7QUFHRSxNQUFBLElBQUksRUFBQyxNQUhQO0FBSUUsTUFBQSxTQUFTLEVBQUMsMkRBSlo7QUFLRSxNQUFBLEtBQUssRUFBRSxLQUFLcEIsS0FBTCxDQUFXRSxRQUxwQjtBQU1FLE1BQUEsUUFBUSxFQUFFLEtBQUttQjtBQU5qQixNQUZGLENBZkosRUEyQkU7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQixvQkFFRTtBQUNFLE1BQUEsR0FBRyxFQUFFLEtBQUsvQixTQUFMLENBQWU4QixXQUFmLENBQTJCLENBQTNCLENBRFA7QUFFRSxNQUFBLFFBQVEsRUFBQyxHQUZYO0FBR0UsTUFBQSxJQUFJLEVBQUUsS0FBS3BCLEtBQUwsQ0FBV1csWUFBWCxHQUEwQixNQUExQixHQUFtQyxVQUgzQztBQUlFLE1BQUEsU0FBUyxFQUFDLDJEQUpaO0FBS0UsTUFBQSxLQUFLLEVBQUUsS0FBS1gsS0FBTCxDQUFXRCxRQUxwQjtBQU1FLE1BQUEsUUFBUSxFQUFFLEtBQUt1QjtBQU5qQixNQUZGLEVBVUU7QUFDRSxNQUFBLFNBQVMsRUFBQyx5REFEWjtBQUVFLE1BQUEsUUFBUSxFQUFDLEdBRlg7QUFHRSxNQUFBLE9BQU8sRUFBRSxLQUFLQztBQUhoQixPQUlHLEtBQUt2QixLQUFMLENBQVdXLFlBQVgsR0FBMEIsTUFBMUIsR0FBbUMsTUFKdEMsQ0FWRixDQTNCRixFQTRDR2YsTUFBTSxDQUFDTyxlQUFQLElBQ0M7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQixPQUNFO0FBQ0UsTUFBQSxRQUFRLEVBQUMsR0FEWDtBQUVFLE1BQUEsU0FBUyxFQUFDLDJDQUZaO0FBR0UsTUFBQSxJQUFJLEVBQUMsVUFIUDtBQUlFLE1BQUEsT0FBTyxFQUFFLEtBQUtILEtBQUwsQ0FBV0ksUUFKdEI7QUFLRSxNQUFBLFFBQVEsRUFBRSxLQUFLb0I7QUFMakIsTUFERixhQTdDSixDQURGO0FBNEREOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQixTQUFLbkMsU0FBTCxDQUFlQyxPQUFmO0FBQ0Q7O0FBaUNEQyxFQUFBQSxTQUFTLEdBQUc7QUFDVixXQUFPLENBQUMsS0FBS0gsS0FBTCxDQUFXTSxPQUFYLENBQW1CRSxTQUFuQixHQUErQkksZUFBaEMsSUFBbUQsS0FBS0QsS0FBTCxDQUFXRSxRQUFYLENBQW9Cd0IsTUFBcEIsR0FBNkIsQ0FBdkY7QUFDRDs7QUFwSTJEOzs7O2dCQUF6Q3pDLGdCLGVBQ0E7QUFDakI7QUFDQVUsRUFBQUEsT0FBTyxFQUFFZ0Msc0JBQVVDLEtBQVYsQ0FBZ0I7QUFDdkIvQixJQUFBQSxTQUFTLEVBQUU4QixzQkFBVUUsSUFBVixDQUFlQyxVQURIO0FBRXZCekIsSUFBQUEsTUFBTSxFQUFFc0Isc0JBQVVFLElBQVYsQ0FBZUMsVUFGQTtBQUd2QmYsSUFBQUEsTUFBTSxFQUFFWSxzQkFBVUUsSUFBVixDQUFlQztBQUhBLEdBQWhCLEVBSU5BLFVBTmM7QUFPakJkLEVBQUFBLFVBQVUsRUFBRVcsc0JBQVVJLElBUEw7QUFRakJkLEVBQUFBLEtBQUssRUFBRVUsc0JBQVVLLFVBQVYsQ0FBcUJDLEtBQXJCLENBUlU7QUFVakI7QUFDQWYsRUFBQUEsU0FBUyxFQUFFUyxzQkFBVU8sTUFBVixDQUFpQkosVUFYWDtBQVlqQlgsRUFBQUEsUUFBUSxFQUFFUSxzQkFBVU8sTUFBVixDQUFpQko7QUFaVixDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuXG5pbXBvcnQgRGlhbG9nVmlldyBmcm9tICcuL2RpYWxvZy12aWV3JztcbmltcG9ydCBBdXRvRm9jdXMgZnJvbSAnLi4vYXV0b2ZvY3VzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ3JlZGVudGlhbERpYWxvZyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gTW9kZWxcbiAgICByZXF1ZXN0OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgZ2V0UGFyYW1zOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgICAgYWNjZXB0OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgICAgY2FuY2VsOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIH0pLmlzUmVxdWlyZWQsXG4gICAgaW5Qcm9ncmVzczogUHJvcFR5cGVzLmJvb2wsXG4gICAgZXJyb3I6IFByb3BUeXBlcy5pbnN0YW5jZU9mKEVycm9yKSxcblxuICAgIC8vIEF0b20gZW52aXJvbm1lbnRcbiAgICB3b3Jrc3BhY2U6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb21tYW5kczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG5cbiAgICB0aGlzLmF1dG9mb2N1cyA9IG5ldyBBdXRvRm9jdXMoKTtcblxuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICB1c2VybmFtZTogJycsXG4gICAgICBwYXNzd29yZDogJycsXG4gICAgICByZW1lbWJlcjogZmFsc2UsXG4gICAgICBzaG93UGFzc3dvcmQ6IGZhbHNlLFxuICAgIH07XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3QgcmVxdWVzdCA9IHRoaXMucHJvcHMucmVxdWVzdDtcbiAgICBjb25zdCBwYXJhbXMgPSByZXF1ZXN0LmdldFBhcmFtcygpO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxEaWFsb2dWaWV3XG4gICAgICAgIHByb21wdD17cGFyYW1zLnByb21wdH1cbiAgICAgICAgYWNjZXB0RW5hYmxlZD17dGhpcy5jYW5TaWduSW4oKX1cbiAgICAgICAgYWNjZXB0VGFiSW5kZXg9ezV9XG4gICAgICAgIGFjY2VwdFRleHQ9XCJTaWduIGluXCJcbiAgICAgICAgY2FuY2VsVGFiSW5kZXg9ezZ9XG4gICAgICAgIGFjY2VwdD17dGhpcy5hY2NlcHR9XG4gICAgICAgIGNhbmNlbD17cmVxdWVzdC5jYW5jZWx9XG4gICAgICAgIGF1dG9mb2N1cz17dGhpcy5hdXRvZm9jdXN9XG4gICAgICAgIGluUHJvZ3Jlc3M9e3RoaXMucHJvcHMuaW5Qcm9ncmVzc31cbiAgICAgICAgZXJyb3I9e3RoaXMucHJvcHMuZXJyb3J9XG4gICAgICAgIHdvcmtzcGFjZT17dGhpcy5wcm9wcy53b3Jrc3BhY2V9XG4gICAgICAgIGNvbW1hbmRzPXt0aGlzLnByb3BzLmNvbW1hbmRzfT5cblxuICAgICAgICB7cGFyYW1zLmluY2x1ZGVVc2VybmFtZSAmJiAoXG4gICAgICAgICAgPGxhYmVsIGNsYXNzTmFtZT1cImdpdGh1Yi1EaWFsb2dMYWJlbCBnaXRodWItRGlhbG9nTGFiZWwtLWhvcml6b250YWxcIj5cbiAgICAgICAgICAgIFVzZXJuYW1lOlxuICAgICAgICAgICAgPGlucHV0XG4gICAgICAgICAgICAgIHJlZj17dGhpcy5hdXRvZm9jdXMuZmlyc3RUYXJnZXQoMCl9XG4gICAgICAgICAgICAgIHRhYkluZGV4PVwiMVwiXG4gICAgICAgICAgICAgIHR5cGU9XCJ0ZXh0XCJcbiAgICAgICAgICAgICAgY2xhc3NOYW1lPVwiaW5wdXQtdGV4dCBuYXRpdmUta2V5LWJpbmRpbmdzIGdpdGh1Yi1DcmVkZW50aWFsLXVzZXJuYW1lXCJcbiAgICAgICAgICAgICAgdmFsdWU9e3RoaXMuc3RhdGUudXNlcm5hbWV9XG4gICAgICAgICAgICAgIG9uQ2hhbmdlPXt0aGlzLmRpZENoYW5nZVVzZXJuYW1lfVxuICAgICAgICAgICAgLz5cbiAgICAgICAgICA8L2xhYmVsPlxuICAgICAgICApfVxuICAgICAgICA8bGFiZWwgY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0xhYmVsIGdpdGh1Yi1EaWFsb2dMYWJlbC0taG9yaXpvbnRhbFwiPlxuICAgICAgICAgIFBhc3N3b3JkOlxuICAgICAgICAgIDxpbnB1dFxuICAgICAgICAgICAgcmVmPXt0aGlzLmF1dG9mb2N1cy5maXJzdFRhcmdldCgxKX1cbiAgICAgICAgICAgIHRhYkluZGV4PVwiMlwiXG4gICAgICAgICAgICB0eXBlPXt0aGlzLnN0YXRlLnNob3dQYXNzd29yZCA/ICd0ZXh0JyA6ICdwYXNzd29yZCd9XG4gICAgICAgICAgICBjbGFzc05hbWU9XCJpbnB1dC10ZXh0IG5hdGl2ZS1rZXktYmluZGluZ3MgZ2l0aHViLUNyZWRlbnRpYWwtcGFzc3dvcmRcIlxuICAgICAgICAgICAgdmFsdWU9e3RoaXMuc3RhdGUucGFzc3dvcmR9XG4gICAgICAgICAgICBvbkNoYW5nZT17dGhpcy5kaWRDaGFuZ2VQYXNzd29yZH1cbiAgICAgICAgICAvPlxuICAgICAgICAgIDxidXR0b25cbiAgICAgICAgICAgIGNsYXNzTmFtZT1cImdpdGh1Yi1EaWFsb2ctLWluc2V0QnV0dG9uIGdpdGh1Yi1DcmVkZW50aWFsLXZpc2liaWxpdHlcIlxuICAgICAgICAgICAgdGFiSW5kZXg9XCIzXCJcbiAgICAgICAgICAgIG9uQ2xpY2s9e3RoaXMudG9nZ2xlU2hvd1Bhc3N3b3JkfT5cbiAgICAgICAgICAgIHt0aGlzLnN0YXRlLnNob3dQYXNzd29yZCA/ICdIaWRlJyA6ICdTaG93J31cbiAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgPC9sYWJlbD5cbiAgICAgICAge3BhcmFtcy5pbmNsdWRlUmVtZW1iZXIgJiYgKFxuICAgICAgICAgIDxsYWJlbCBjbGFzc05hbWU9XCJnaXRodWItRGlhbG9nTGFiZWwgZ2l0aHViLURpYWxvZ0xhYmVsLS1ob3Jpem9udGFsIGdpdGh1Yi1DcmVkZW50aWFsLXJlbWVtYmVyTGFiZWxcIj5cbiAgICAgICAgICAgIDxpbnB1dFxuICAgICAgICAgICAgICB0YWJJbmRleD1cIjRcIlxuICAgICAgICAgICAgICBjbGFzc05hbWU9XCJpbnB1dC1jaGVja2JveCBnaXRodWItQ3JlZGVudGlhbC1yZW1lbWJlclwiXG4gICAgICAgICAgICAgIHR5cGU9XCJjaGVja2JveFwiXG4gICAgICAgICAgICAgIGNoZWNrZWQ9e3RoaXMuc3RhdGUucmVtZW1iZXJ9XG4gICAgICAgICAgICAgIG9uQ2hhbmdlPXt0aGlzLmRpZENoYW5nZVJlbWVtYmVyfVxuICAgICAgICAgICAgLz5cbiAgICAgICAgICAgIFJlbWVtYmVyXG4gICAgICAgICAgPC9sYWJlbD5cbiAgICAgICAgKX1cblxuICAgICAgPC9EaWFsb2dWaWV3PlxuICAgICk7XG4gIH1cblxuICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICB0aGlzLmF1dG9mb2N1cy50cmlnZ2VyKCk7XG4gIH1cblxuICByZWNhcHR1cmVGb2N1cyA9ICgpID0+IHRoaXMuYXV0b2ZvY3VzLnRyaWdnZXIoKTtcblxuICBhY2NlcHQgPSAoKSA9PiB7XG4gICAgaWYgKCF0aGlzLmNhblNpZ25JbigpKSB7XG4gICAgICByZXR1cm4gUHJvbWlzZS5yZXNvbHZlKCk7XG4gICAgfVxuXG4gICAgY29uc3QgcmVxdWVzdCA9IHRoaXMucHJvcHMucmVxdWVzdDtcbiAgICBjb25zdCBwYXJhbXMgPSByZXF1ZXN0LmdldFBhcmFtcygpO1xuXG4gICAgY29uc3QgcGF5bG9hZCA9IHtwYXNzd29yZDogdGhpcy5zdGF0ZS5wYXNzd29yZH07XG5cbiAgICBpZiAocGFyYW1zLmluY2x1ZGVVc2VybmFtZSkge1xuICAgICAgcGF5bG9hZC51c2VybmFtZSA9IHRoaXMuc3RhdGUudXNlcm5hbWU7XG4gICAgfVxuXG4gICAgaWYgKHBhcmFtcy5pbmNsdWRlUmVtZW1iZXIpIHtcbiAgICAgIHBheWxvYWQucmVtZW1iZXIgPSB0aGlzLnN0YXRlLnJlbWVtYmVyO1xuICAgIH1cblxuICAgIHJldHVybiByZXF1ZXN0LmFjY2VwdChwYXlsb2FkKTtcbiAgfVxuXG4gIGRpZENoYW5nZVVzZXJuYW1lID0gZSA9PiB0aGlzLnNldFN0YXRlKHt1c2VybmFtZTogZS50YXJnZXQudmFsdWV9KTtcblxuICBkaWRDaGFuZ2VQYXNzd29yZCA9IGUgPT4gdGhpcy5zZXRTdGF0ZSh7cGFzc3dvcmQ6IGUudGFyZ2V0LnZhbHVlfSk7XG5cbiAgZGlkQ2hhbmdlUmVtZW1iZXIgPSBlID0+IHRoaXMuc2V0U3RhdGUoe3JlbWVtYmVyOiBlLnRhcmdldC5jaGVja2VkfSk7XG5cbiAgdG9nZ2xlU2hvd1Bhc3N3b3JkID0gKCkgPT4gdGhpcy5zZXRTdGF0ZSh7c2hvd1Bhc3N3b3JkOiAhdGhpcy5zdGF0ZS5zaG93UGFzc3dvcmR9KTtcblxuICBjYW5TaWduSW4oKSB7XG4gICAgcmV0dXJuICF0aGlzLnByb3BzLnJlcXVlc3QuZ2V0UGFyYW1zKCkuaW5jbHVkZVVzZXJuYW1lIHx8IHRoaXMuc3RhdGUudXNlcm5hbWUubGVuZ3RoID4gMDtcbiAgfVxufVxuIl19