"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CreatePullRequestTile extends _react["default"].Component {
  render() {
    if (this.isRepositoryNotFound()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, _react["default"].createElement("strong", null, "Repository not found"), " for the remote ", _react["default"].createElement("code", null, this.props.remote.getName()), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "link"
      }), "Do you need to update your ", _react["default"].createElement("strong", null, "remote URL"), "?");
    }

    if (this.isDetachedHead()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "You are not currently on ", _react["default"].createElement("strong", null, "any branch"), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "git-branch"
      }), _react["default"].createElement("strong", null, "Create a new branch"), "\xA0 to share your work with a pull request.");
    }

    if (this.hasNoDefaultRef()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "The repository at remote ", _react["default"].createElement("code", null, this.props.remote.getName()), " is ", _react["default"].createElement("strong", null, "empty"), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "arrow-up"
      }), _react["default"].createElement("strong", null, "Push a main branch"), " to begin sharing your work.");
    }

    if (this.isOnDefaultRef()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "You are currently on your repository's ", _react["default"].createElement("strong", null, "default branch"), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "git-branch"
      }), _react["default"].createElement("strong", null, "Checkout or create a new branch"), "\xA0 to share your work with a pull request.");
    }

    if (this.isSameAsDefaultRef()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "Your current branch ", _react["default"].createElement("strong", null, "has not moved"), " from the repository's default branch.", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "git-commit"
      }), _react["default"].createElement("strong", null, "Make some commits"), "\xA0 to share your work with a pull request.");
    }

    let message = 'Open new pull request';
    let disable = false;
    const differentRemote = this.pushesToDifferentRemote();

    if (this.props.pushInProgress) {
      message = 'Pushing...';
      disable = true;
    } else if (!this.hasUpstreamBranch() || differentRemote) {
      message = 'Publish + open new pull request';
    } else if (this.props.aheadCount > 0) {
      message = 'Push + open new pull request';
    }

    return _react["default"].createElement("div", null, differentRemote && _react["default"].createElement("div", {
      className: "github-CreatePullRequestTile-message"
    }, "Your current branch is ", _react["default"].createElement("strong", null, "configured"), " to push to the remote ", _react["default"].createElement("code", null, this.props.branches.getHeadBranch().getPush().getRemoteName()), ".", _react["default"].createElement("hr", {
      className: "github-CreatePullRequestTile-divider"
    }), _react["default"].createElement(_octicon["default"], {
      icon: "cloud-upload"
    }), _react["default"].createElement("strong", null, "Publish"), " it to ", _react["default"].createElement("code", null, this.props.remote.getName()), " instead?"), _react["default"].createElement("div", {
      className: "github-CreatePullRequestTile-controls"
    }, _react["default"].createElement("button", {
      className: "github-CreatePullRequestTile-createPr btn btn-primary",
      onClick: this.props.onCreatePr,
      disabled: disable
    }, message)));
  }

  isRepositoryNotFound() {
    return !this.props.repository;
  }

  isDetachedHead() {
    return !this.props.branches.getHeadBranch().isPresent();
  }

  hasNoDefaultRef() {
    return !this.props.repository.defaultBranchRef;
  }

  isOnDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }

    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */

    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    return currentBranch.getPush().getRemoteRef() === `${defaultRef.prefix}${defaultRef.name}`;
  }

  isSameAsDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }

    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */

    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    const mainBranches = this.props.branches.getPushSources(this.props.remote.getName(), `${defaultRef.prefix}${defaultRef.name}`);
    return mainBranches.some(branch => branch.getSha() === currentBranch.getSha());
  }

  pushesToDifferentRemote() {
    const p = this.props.branches.getHeadBranch().getPush();

    if (!p.isRemoteTracking()) {
      return false;
    }

    const pushRemoteName = p.getRemoteName();
    return pushRemoteName !== this.props.remote.getName();
  }

  hasUpstreamBranch() {
    return this.props.branches.getHeadBranch().getUpstream().isPresent();
  }

}

exports["default"] = CreatePullRequestTile;

_defineProperty(CreatePullRequestTile, "propTypes", {
  repository: _propTypes["default"].shape({
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  remote: _propTypes2.RemotePropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  onCreatePr: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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