"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCheckSuiteView = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _checkRunView = _interopRequireDefault(require("./check-run-view"));

var _buildStatus = require("../models/build-status");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCheckSuiteView extends _react["default"].Component {
  render() {
    const {
      icon,
      classSuffix
    } = (0, _buildStatus.buildStatusFromCheckResult)(this.props.checkSuite);
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("li", {
      className: "github-PrStatuses-list-item"
    }, _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-icon"
    }, _react["default"].createElement(_octicon["default"], {
      icon: icon,
      className: `github-PrStatuses--${classSuffix}`
    })), this.props.checkSuite.app && _react["default"].createElement("span", {
      className: "github-PrStatuses-list-item-context"
    }, _react["default"].createElement("strong", null, this.props.checkSuite.app.name))), this.props.checkRuns.map(run => _react["default"].createElement(_checkRunView["default"], {
      key: run.id,
      checkRun: run,
      switchToIssueish: this.props.switchToIssueish
    })));
  }

}

exports.BareCheckSuiteView = BareCheckSuiteView;

_defineProperty(BareCheckSuiteView, "propTypes", {
  // Relay
  checkSuite: _propTypes["default"].shape({
    app: _propTypes["default"].shape({
      name: _propTypes["default"].string.isRequired
    }),
    status: _propTypes["default"].oneOf(['QUEUED', 'IN_PROGRESS', 'COMPLETED', 'REQUESTED']).isRequired,
    conclusion: _propTypes["default"].oneOf(['ACTION_REQUIRED', 'TIMED_OUT', 'CANCELLED', 'FAILURE', 'SUCCESS', 'NEUTRAL'])
  }).isRequired,
  checkRuns: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  })).isRequired,
  // Actions
  switchToIssueish: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCheckSuiteView, {
  checkSuite: function () {
    const node = require("./__generated__/checkSuiteView_checkSuite.graphql");

    if (node.hash && node.hash !== "ab1475671a1bc4196d67bfa75ad41446") {
      console.error("The definition of 'checkSuiteView_checkSuite' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkSuiteView_checkSuite.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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