"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _propTypes2 = require("../prop-types");

var _gitShellOutStrategy = require("../git-shell-out-strategy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BranchMenuView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      createNew: false,
      checkedOutBranch: null
    });

    _defineProperty(this, "didSelectItem", async event => {
      const branchName = event.target.value;
      await this.checkout(branchName);
    });

    _defineProperty(this, "createBranch", async () => {
      if (this.state.createNew) {
        const branchName = this.editorElement.getModel().getText().trim();
        await this.checkout(branchName, {
          createNew: true
        });
      } else {
        await new Promise(resolve => {
          this.setState({
            createNew: true
          }, () => {
            this.editorElement.focus();
            resolve();
          });
        });
      }
    });

    _defineProperty(this, "checkout", async (branchName, options) => {
      this.editorElement.classList.remove('is-focused');
      await new Promise(resolve => {
        this.setState({
          checkedOutBranch: branchName
        }, resolve);
      });

      try {
        await this.props.checkout(branchName, options);
        await new Promise(resolve => {
          this.setState({
            checkedOutBranch: null,
            createNew: false
          }, resolve);
        });
        this.editorElement.getModel().setText('');
      } catch (error) {
        this.editorElement.classList.add('is-focused');
        await new Promise(resolve => {
          this.setState({
            checkedOutBranch: null
          }, resolve);
        });

        if (!(error instanceof _gitShellOutStrategy.GitError)) {
          throw error;
        }
      }
    });

    _defineProperty(this, "cancelCreateNewBranch", () => {
      this.setState({
        createNew: false
      });
    });
  }

  render() {
    const branchNames = this.props.branches.getNames().filter(Boolean);
    let currentBranchName = this.props.currentBranch.isDetached() ? 'detached' : this.props.currentBranch.getName();

    if (this.state.checkedOutBranch) {
      currentBranchName = this.state.checkedOutBranch;

      if (branchNames.indexOf(this.state.checkedOutBranch) === -1) {
        branchNames.push(this.state.checkedOutBranch);
      }
    }

    const disableControls = !!this.state.checkedOutBranch;
    const branchEditorClasses = (0, _classnames["default"])('github-BranchMenuView-item', 'github-BranchMenuView-editor', {
      hidden: !this.state.createNew
    });
    const branchSelectListClasses = (0, _classnames["default"])('github-BranchMenuView-item', 'github-BranchMenuView-select', 'input-select', {
      hidden: !!this.state.createNew
    });
    const iconClasses = (0, _classnames["default"])('github-BranchMenuView-item', 'icon', {
      'icon-git-branch': !disableControls,
      'icon-sync': disableControls
    });

    const newBranchEditor = _react["default"].createElement("div", {
      className: branchEditorClasses
    }, _react["default"].createElement("atom-text-editor", {
      ref: e => {
        this.editorElement = e;
      },
      mini: true,
      readonly: disableControls ? true : undefined
    }));

    const selectBranchView =
    /* eslint-disable jsx-a11y/no-onchange */
    _react["default"].createElement("select", {
      className: branchSelectListClasses,
      onChange: this.didSelectItem,
      disabled: disableControls,
      value: currentBranchName
    }, this.props.currentBranch.isDetached() && _react["default"].createElement("option", {
      key: "detached",
      value: "detached",
      disabled: true
    }, this.props.currentBranch.getName()), branchNames.map(branchName => {
      return _react["default"].createElement("option", {
        key: `branch-${branchName}`,
        value: branchName
      }, branchName);
    }));

    return _react["default"].createElement("div", {
      className: "github-BranchMenuView"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: ".github-BranchMenuView-editor atom-text-editor[mini]"
    }, _react["default"].createElement(_commands.Command, {
      command: "tool-panel:unfocus",
      callback: this.cancelCreateNewBranch
    }), _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancelCreateNewBranch
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.createBranch
    })), _react["default"].createElement("div", {
      className: "github-BranchMenuView-selector"
    }, _react["default"].createElement("span", {
      className: iconClasses
    }), newBranchEditor, selectBranchView, _react["default"].createElement("button", {
      className: "github-BranchMenuView-item github-BranchMenuView-button btn",
      onClick: this.createBranch,
      disabled: disableControls
    }, " New Branch ")));
  }

}

exports["default"] = BranchMenuView;

_defineProperty(BranchMenuView, "propTypes", {
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  notificationManager: _propTypes["default"].object.isRequired,
  // Model
  repository: _propTypes["default"].object,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  checkout: _propTypes["default"].func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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