"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * The working directory exists, but contains no git repository yet.
 */
class Empty extends _state["default"] {
  isEmpty() {
    return true;
  }

  init() {
    return this.transitionTo('Initializing');
  }

  clone(remoteUrl) {
    return this.transitionTo('Cloning', remoteUrl);
  }

  showGitTabInit() {
    return true;
  }

}

exports["default"] = Empty;

_state["default"].register(Empty);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVtcHR5LmpzIl0sIm5hbWVzIjpbIkVtcHR5IiwiU3RhdGUiLCJpc0VtcHR5IiwiaW5pdCIsInRyYW5zaXRpb25UbyIsImNsb25lIiwicmVtb3RlVXJsIiwic2hvd0dpdFRhYkluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBRUE7OztBQUdlLE1BQU1BLEtBQU4sU0FBb0JDLGlCQUFwQixDQUEwQjtBQUN2Q0MsRUFBQUEsT0FBTyxHQUFHO0FBQ1IsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLElBQUksR0FBRztBQUNMLFdBQU8sS0FBS0MsWUFBTCxDQUFrQixjQUFsQixDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLEtBQUssQ0FBQ0MsU0FBRCxFQUFZO0FBQ2YsV0FBTyxLQUFLRixZQUFMLENBQWtCLFNBQWxCLEVBQTZCRSxTQUE3QixDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLGNBQWMsR0FBRztBQUNmLFdBQU8sSUFBUDtBQUNEOztBQWZzQzs7OztBQWtCekNOLGtCQUFNTyxRQUFOLENBQWVSLEtBQWYiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIFRoZSB3b3JraW5nIGRpcmVjdG9yeSBleGlzdHMsIGJ1dCBjb250YWlucyBubyBnaXQgcmVwb3NpdG9yeSB5ZXQuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEVtcHR5IGV4dGVuZHMgU3RhdGUge1xuICBpc0VtcHR5KCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaW5pdCgpIHtcbiAgICByZXR1cm4gdGhpcy50cmFuc2l0aW9uVG8oJ0luaXRpYWxpemluZycpO1xuICB9XG5cbiAgY2xvbmUocmVtb3RlVXJsKSB7XG4gICAgcmV0dXJuIHRoaXMudHJhbnNpdGlvblRvKCdDbG9uaW5nJywgcmVtb3RlVXJsKTtcbiAgfVxuXG4gIHNob3dHaXRUYWJJbml0KCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKEVtcHR5KTtcbiJdfQ==