"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpoint = getEndpoint;

// API endpoint for a GitHub instance, either dotcom or an Enterprise installation.
class Endpoint {
  constructor(host, apiHost, apiRouteParts) {
    this.host = host;
    this.apiHost = apiHost;
    this.apiRoute = apiRouteParts.map(encodeURIComponent).join('/');
  }

  getRestURI(...parts) {
    const sep = parts.length > 0 ? '/' : '';
    return this.getRestRoot() + sep + parts.map(encodeURIComponent).join('/');
  }

  getGraphQLRoot() {
    return this.getRestURI('graphql');
  }

  getRestRoot() {
    const sep = this.apiRoute !== '' ? '/' : '';
    return `https://${this.apiHost}${sep}${this.apiRoute}`;
  }

  getHost() {
    return this.host;
  }

  getLoginAccount() {
    return `https://${this.apiHost}`;
  }

} // API endpoint for GitHub.com


const dotcomEndpoint = new Endpoint('github.com', 'api.github.com', []);

function getEndpoint(host) {
  if (host === 'github.com') {
    return dotcomEndpoint;
  } else {
    return new Endpoint(host, host, ['api', 'v3']);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZHBvaW50LmpzIl0sIm5hbWVzIjpbIkVuZHBvaW50IiwiY29uc3RydWN0b3IiLCJob3N0IiwiYXBpSG9zdCIsImFwaVJvdXRlUGFydHMiLCJhcGlSb3V0ZSIsIm1hcCIsImVuY29kZVVSSUNvbXBvbmVudCIsImpvaW4iLCJnZXRSZXN0VVJJIiwicGFydHMiLCJzZXAiLCJsZW5ndGgiLCJnZXRSZXN0Um9vdCIsImdldEdyYXBoUUxSb290IiwiZ2V0SG9zdCIsImdldExvZ2luQWNjb3VudCIsImRvdGNvbUVuZHBvaW50IiwiZ2V0RW5kcG9pbnQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTtBQUNBLE1BQU1BLFFBQU4sQ0FBZTtBQUNiQyxFQUFBQSxXQUFXLENBQUNDLElBQUQsRUFBT0MsT0FBUCxFQUFnQkMsYUFBaEIsRUFBK0I7QUFDeEMsU0FBS0YsSUFBTCxHQUFZQSxJQUFaO0FBQ0EsU0FBS0MsT0FBTCxHQUFlQSxPQUFmO0FBQ0EsU0FBS0UsUUFBTCxHQUFnQkQsYUFBYSxDQUFDRSxHQUFkLENBQWtCQyxrQkFBbEIsRUFBc0NDLElBQXRDLENBQTJDLEdBQTNDLENBQWhCO0FBQ0Q7O0FBRURDLEVBQUFBLFVBQVUsQ0FBQyxHQUFHQyxLQUFKLEVBQVc7QUFDbkIsVUFBTUMsR0FBRyxHQUFHRCxLQUFLLENBQUNFLE1BQU4sR0FBZSxDQUFmLEdBQW1CLEdBQW5CLEdBQXlCLEVBQXJDO0FBQ0EsV0FBTyxLQUFLQyxXQUFMLEtBQXFCRixHQUFyQixHQUEyQkQsS0FBSyxDQUFDSixHQUFOLENBQVVDLGtCQUFWLEVBQThCQyxJQUE5QixDQUFtQyxHQUFuQyxDQUFsQztBQUNEOztBQUVETSxFQUFBQSxjQUFjLEdBQUc7QUFDZixXQUFPLEtBQUtMLFVBQUwsQ0FBZ0IsU0FBaEIsQ0FBUDtBQUNEOztBQUVESSxFQUFBQSxXQUFXLEdBQUc7QUFDWixVQUFNRixHQUFHLEdBQUcsS0FBS04sUUFBTCxLQUFrQixFQUFsQixHQUF1QixHQUF2QixHQUE2QixFQUF6QztBQUNBLFdBQVEsV0FBVSxLQUFLRixPQUFRLEdBQUVRLEdBQUksR0FBRSxLQUFLTixRQUFTLEVBQXJEO0FBQ0Q7O0FBRURVLEVBQUFBLE9BQU8sR0FBRztBQUNSLFdBQU8sS0FBS2IsSUFBWjtBQUNEOztBQUVEYyxFQUFBQSxlQUFlLEdBQUc7QUFDaEIsV0FBUSxXQUFVLEtBQUtiLE9BQVEsRUFBL0I7QUFDRDs7QUEzQlksQyxDQThCZjs7O0FBQ0EsTUFBTWMsY0FBYyxHQUFHLElBQUlqQixRQUFKLENBQWEsWUFBYixFQUEyQixnQkFBM0IsRUFBNkMsRUFBN0MsQ0FBdkI7O0FBRU8sU0FBU2tCLFdBQVQsQ0FBcUJoQixJQUFyQixFQUEyQjtBQUNoQyxNQUFJQSxJQUFJLEtBQUssWUFBYixFQUEyQjtBQUN6QixXQUFPZSxjQUFQO0FBQ0QsR0FGRCxNQUVPO0FBQ0wsV0FBTyxJQUFJakIsUUFBSixDQUFhRSxJQUFiLEVBQW1CQSxJQUFuQixFQUF5QixDQUFDLEtBQUQsRUFBUSxJQUFSLENBQXpCLENBQVA7QUFDRDtBQUNGIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbIi8vIEFQSSBlbmRwb2ludCBmb3IgYSBHaXRIdWIgaW5zdGFuY2UsIGVpdGhlciBkb3Rjb20gb3IgYW4gRW50ZXJwcmlzZSBpbnN0YWxsYXRpb24uXG5jbGFzcyBFbmRwb2ludCB7XG4gIGNvbnN0cnVjdG9yKGhvc3QsIGFwaUhvc3QsIGFwaVJvdXRlUGFydHMpIHtcbiAgICB0aGlzLmhvc3QgPSBob3N0O1xuICAgIHRoaXMuYXBpSG9zdCA9IGFwaUhvc3Q7XG4gICAgdGhpcy5hcGlSb3V0ZSA9IGFwaVJvdXRlUGFydHMubWFwKGVuY29kZVVSSUNvbXBvbmVudCkuam9pbignLycpO1xuICB9XG5cbiAgZ2V0UmVzdFVSSSguLi5wYXJ0cykge1xuICAgIGNvbnN0IHNlcCA9IHBhcnRzLmxlbmd0aCA+IDAgPyAnLycgOiAnJztcbiAgICByZXR1cm4gdGhpcy5nZXRSZXN0Um9vdCgpICsgc2VwICsgcGFydHMubWFwKGVuY29kZVVSSUNvbXBvbmVudCkuam9pbignLycpO1xuICB9XG5cbiAgZ2V0R3JhcGhRTFJvb3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UmVzdFVSSSgnZ3JhcGhxbCcpO1xuICB9XG5cbiAgZ2V0UmVzdFJvb3QoKSB7XG4gICAgY29uc3Qgc2VwID0gdGhpcy5hcGlSb3V0ZSAhPT0gJycgPyAnLycgOiAnJztcbiAgICByZXR1cm4gYGh0dHBzOi8vJHt0aGlzLmFwaUhvc3R9JHtzZXB9JHt0aGlzLmFwaVJvdXRlfWA7XG4gIH1cblxuICBnZXRIb3N0KCkge1xuICAgIHJldHVybiB0aGlzLmhvc3Q7XG4gIH1cblxuICBnZXRMb2dpbkFjY291bnQoKSB7XG4gICAgcmV0dXJuIGBodHRwczovLyR7dGhpcy5hcGlIb3N0fWA7XG4gIH1cbn1cblxuLy8gQVBJIGVuZHBvaW50IGZvciBHaXRIdWIuY29tXG5jb25zdCBkb3Rjb21FbmRwb2ludCA9IG5ldyBFbmRwb2ludCgnZ2l0aHViLmNvbScsICdhcGkuZ2l0aHViLmNvbScsIFtdKTtcblxuZXhwb3J0IGZ1bmN0aW9uIGdldEVuZHBvaW50KGhvc3QpIHtcbiAgaWYgKGhvc3QgPT09ICdnaXRodWIuY29tJykge1xuICAgIHJldHVybiBkb3Rjb21FbmRwb2ludDtcbiAgfSBlbHNlIHtcbiAgICByZXR1cm4gbmV3IEVuZHBvaW50KGhvc3QsIGhvc3QsIFsnYXBpJywgJ3YzJ10pO1xuICB9XG59XG4iXX0=