"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _markerTools = require("./marker-tools");

class Separator {
  constructor(editor, marker) {
    this.editor = editor;
    this.marker = marker;
  }

  getMarker() {
    return this.marker;
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }

  isModified() {
    const currentText = this.editor.getTextInBufferRange(this.getMarker().getBufferRange());
    return !/^=======\r?\n?$/.test(currentText);
  }

}

exports["default"] = Separator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlcGFyYXRvci5qcyJdLCJuYW1lcyI6WyJTZXBhcmF0b3IiLCJjb25zdHJ1Y3RvciIsImVkaXRvciIsIm1hcmtlciIsImdldE1hcmtlciIsImRlbGV0ZSIsImlzTW9kaWZpZWQiLCJjdXJyZW50VGV4dCIsImdldFRleHRJbkJ1ZmZlclJhbmdlIiwiZ2V0QnVmZmVyUmFuZ2UiLCJ0ZXN0Il0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBRWUsTUFBTUEsU0FBTixDQUFnQjtBQUM3QkMsRUFBQUEsV0FBVyxDQUFDQyxNQUFELEVBQVNDLE1BQVQsRUFBaUI7QUFDMUIsU0FBS0QsTUFBTCxHQUFjQSxNQUFkO0FBQ0EsU0FBS0MsTUFBTCxHQUFjQSxNQUFkO0FBQ0Q7O0FBRURDLEVBQUFBLFNBQVMsR0FBRztBQUNWLFdBQU8sS0FBS0QsTUFBWjtBQUNEOztBQUVERSxFQUFBQSxNQUFNLEdBQUc7QUFDUCxxQ0FBZSxLQUFLRCxTQUFMLEVBQWYsRUFBaUMsS0FBS0YsTUFBdEM7QUFDRDs7QUFFREksRUFBQUEsVUFBVSxHQUFHO0FBQ1gsVUFBTUMsV0FBVyxHQUFHLEtBQUtMLE1BQUwsQ0FBWU0sb0JBQVosQ0FBaUMsS0FBS0osU0FBTCxHQUFpQkssY0FBakIsRUFBakMsQ0FBcEI7QUFDQSxXQUFPLENBQUMsa0JBQWtCQyxJQUFsQixDQUF1QkgsV0FBdkIsQ0FBUjtBQUNEOztBQWpCNEIiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtkZWxldGVNYXJrZXJJbn0gZnJvbSAnLi9tYXJrZXItdG9vbHMnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBTZXBhcmF0b3Ige1xuICBjb25zdHJ1Y3RvcihlZGl0b3IsIG1hcmtlcikge1xuICAgIHRoaXMuZWRpdG9yID0gZWRpdG9yO1xuICAgIHRoaXMubWFya2VyID0gbWFya2VyO1xuICB9XG5cbiAgZ2V0TWFya2VyKCkge1xuICAgIHJldHVybiB0aGlzLm1hcmtlcjtcbiAgfVxuXG4gIGRlbGV0ZSgpIHtcbiAgICBkZWxldGVNYXJrZXJJbih0aGlzLmdldE1hcmtlcigpLCB0aGlzLmVkaXRvcik7XG4gIH1cblxuICBpc01vZGlmaWVkKCkge1xuICAgIGNvbnN0IGN1cnJlbnRUZXh0ID0gdGhpcy5lZGl0b3IuZ2V0VGV4dEluQnVmZmVyUmFuZ2UodGhpcy5nZXRNYXJrZXIoKS5nZXRCdWZmZXJSYW5nZSgpKTtcbiAgICByZXR1cm4gIS9ePT09PT09PVxccj9cXG4/JC8udGVzdChjdXJyZW50VGV4dCk7XG4gIH1cbn1cbiJdfQ==