"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BIN_SCRIPTS = void 0;

var _os = _interopRequireDefault(require("os"));

var _path = _interopRequireDefault(require("path"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _helpers = require("./helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

const BIN_SCRIPTS = {
  getCredentialHelperJs: 'git-credential-atom.js',
  getCredentialHelperSh: 'git-credential-atom.sh',
  getAskPassJs: 'git-askpass-atom.js',
  getAskPassSh: 'git-askpass-atom.sh',
  getSshWrapperSh: 'linux-ssh-wrapper.sh',
  getGpgWrapperSh: 'gpg-wrapper.sh'
};
exports.BIN_SCRIPTS = BIN_SCRIPTS;

class GitTempDir {
  constructor() {
    this.created = false;
  }

  async ensure() {
    if (this.created) {
      return;
    }

    this.root = await (0, _helpers.getTempDir)({
      dir: process.platform === 'win32' ? _os["default"].tmpdir() : '/tmp',
      prefix: 'github-',
      symlinkOk: true
    });
    await Promise.all(Object.values(BIN_SCRIPTS).map(async filename => {
      await _fsExtra["default"].copy(_path["default"].resolve((0, _helpers.getPackageRoot)(), 'bin', filename), _path["default"].join(this.root, filename));

      if (_path["default"].extname(filename) === '.sh') {
        await _fsExtra["default"].chmod(_path["default"].join(this.root, filename), 0o700);
      }
    }));
    this.created = true;
  }

  getRootPath() {
    return this.root;
  }

  getScriptPath(filename) {
    if (!this.created) {
      throw new Error(`Attempt to access filename ${filename} in uninitialized GitTempDir`);
    }

    return _path["default"].join(this.root, filename);
  }

  getSocketPath() {
    if (process.platform === 'win32') {
      if (!this.socketPath) {
        this.socketPath = _path["default"].join('\\\\?\\pipe\\', 'gh-' + require('crypto').randomBytes(8).toString('hex'), 'helper.sock');
      }

      return this.socketPath;
    } else {
      return this.getScriptPath('helper.sock');
    }
  }

  dispose() {
    return _fsExtra["default"].remove(this.root);
  }

}

exports["default"] = GitTempDir;

function createGetter(key) {
  const filename = BIN_SCRIPTS[key];
  return function () {
    return this.getScriptPath(filename);
  };
}

for (const key in BIN_SCRIPTS) {
  GitTempDir.prototype[key] = createGetter(key);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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