"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _propTypes2 = require("../prop-types");

var _search = _interopRequireDefault(require("../models/search"));

var _issueishSearchContainer = _interopRequireDefault(require("../containers/issueish-search-container"));

var _currentPullRequestContainer = _interopRequireDefault(require("../containers/current-pull-request-container"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchesController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {});

    _defineProperty(this, "onOpenReviews", issueish => {
      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      });

      return this.props.workspace.open(uri).then(() => {
        (0, _reporterProxy.addEvent)('open-reviews-tab', {
          "package": 'github',
          from: this.constructor.name
        });
      });
    });

    _defineProperty(this, "onOpenIssueish", issueish => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      }), {
        pending: true,
        searchAllPanes: true
      }).then(() => {
        (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
          "package": 'github',
          from: 'issueish-list'
        });
      });
    });

    _defineProperty(this, "onOpenSearch", search => {
      const searchURL = search.getWebURL(this.props.remote);
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(searchURL, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
          }
        });
      });
    });
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search["default"].inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-IssueishSearch"
    }, _react["default"].createElement(_currentPullRequestContainer["default"], {
      repository: this.props.repository,
      token: this.props.token,
      endpoint: this.props.endpoint,
      remoteOperationObserver: this.props.remoteOperationObserver,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      workspace: this.props.workspace,
      workingDirectory: this.props.workingDirectory,
      onOpenIssueish: this.onOpenIssueish,
      onOpenReviews: this.onOpenReviews,
      onCreatePr: this.props.onCreatePr
    }), this.state.searches.map(search => _react["default"].createElement(_issueishSearchContainer["default"], {
      key: search.getName(),
      token: this.props.token,
      endpoint: this.props.endpoint,
      search: search,
      remoteOperationObserver: this.props.remoteOperationObserver,
      onOpenIssueish: this.onOpenIssueish,
      onOpenSearch: this.onOpenSearch,
      onOpenReviews: this.onOpenReviews
    })));
  }

}

exports["default"] = IssueishSearchesController;

_defineProperty(IssueishSearchesController, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  // Actions
  onCreatePr: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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