"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishDetailController = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _issueDetailView = _interopRequireDefault(require("../views/issue-detail-view"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

var _prCheckoutController = _interopRequireDefault(require("./pr-checkout-controller"));

var _prDetailView = _interopRequireDefault(require("../views/pr-detail-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareIssueishDetailController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "openCommit", async ({
      sha
    }) => {
      /* istanbul ignore if */
      if (!this.props.workdirPath) {
        return;
      }

      const uri = _commitDetailItem["default"].buildURI(this.props.workdirPath, sha);

      await this.props.workspace.open(uri, {
        pending: true
      });
      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "openReviews", async () => {
      /* istanbul ignore if */
      if (this.getTypename() !== 'PullRequest') {
        return;
      }

      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.repository.owner.login,
        repo: this.props.repository.name,
        number: this.props.issueishNumber,
        workdir: this.props.workdirPath
      });

      await this.props.workspace.open(uri);
      (0, _reporterProxy.addEvent)('open-reviews-tab', {
        "package": 'github',
        from: this.constructor.name
      });
    });
  }

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const {
      repository
    } = this.props;

    if (repository && (repository.issue || repository.pullRequest)) {
      let prefix, issueish;

      if (this.getTypename() === 'PullRequest') {
        prefix = 'PR:';
        issueish = repository.pullRequest;
      } else {
        prefix = 'Issue:';
        issueish = repository.issue;
      }

      const title = `${prefix} ${repository.owner.login}/${repository.name}#${issueish.number} — ${issueish.title}`;
      this.props.onTitleChange(title);
    }
  }

  render() {
    const {
      repository
    } = this.props;

    if (!repository || !repository.issue || !repository.pullRequest) {
      return _react["default"].createElement("div", null, "Issue/PR #", this.props.issueishNumber, " not found"); // TODO: no PRs
    }

    if (this.getTypename() === 'PullRequest') {
      return _react["default"].createElement(_prCheckoutController["default"], {
        repository: repository,
        pullRequest: repository.pullRequest,
        localRepository: this.props.localRepository,
        isAbsent: this.props.isAbsent,
        isLoading: this.props.isLoading,
        isPresent: this.props.isPresent,
        isMerging: this.props.isMerging,
        isRebasing: this.props.isRebasing,
        branches: this.props.branches,
        remotes: this.props.remotes
      }, checkoutOp => _react["default"].createElement(_prDetailView["default"], {
        relay: this.props.relay,
        repository: this.props.repository,
        pullRequest: this.props.repository.pullRequest,
        checkoutOp: checkoutOp,
        localRepository: this.props.localRepository,
        reviewCommentsLoading: this.props.reviewCommentsLoading,
        reviewCommentsTotalCount: this.props.reviewCommentsTotalCount,
        reviewCommentsResolvedCount: this.props.reviewCommentsResolvedCount,
        reviewCommentThreads: this.props.reviewCommentThreads,
        endpoint: this.props.endpoint,
        token: this.props.token,
        workspace: this.props.workspace,
        commands: this.props.commands,
        keymaps: this.props.keymaps,
        tooltips: this.props.tooltips,
        config: this.props.config,
        openCommit: this.openCommit,
        openReviews: this.openReviews,
        switchToIssueish: this.props.switchToIssueish,
        destroy: this.props.destroy,
        reportRelayError: this.props.reportRelayError,
        itemType: this.props.itemType,
        refEditor: this.props.refEditor,
        initChangedFilePath: this.props.initChangedFilePath,
        initChangedFilePosition: this.props.initChangedFilePosition,
        selectedTab: this.props.selectedTab,
        onTabSelected: this.props.onTabSelected,
        onOpenFilesTab: this.props.onOpenFilesTab,
        workdirPath: this.props.workdirPath
      }));
    } else {
      return _react["default"].createElement(_issueDetailView["default"], {
        repository: repository,
        issue: repository.issue,
        switchToIssueish: this.props.switchToIssueish,
        tooltips: this.props.tooltips,
        reportRelayError: this.props.reportRelayError
      });
    }
  }

  getTypename() {
    const {
      repository
    } = this.props;
    /* istanbul ignore if */

    if (!repository) {
      return null;
    }
    /* istanbul ignore if */


    if (!repository.pullRequest) {
      return null;
    }

    return repository.pullRequest.__typename;
  }

}

exports.BareIssueishDetailController = BareIssueishDetailController;

_defineProperty(BareIssueishDetailController, "propTypes", {
  // Relay response
  relay: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    owner: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired
    }).isRequired,
    pullRequest: _propTypes["default"].any,
    issue: _propTypes["default"].any
  }),
  // Local Repository model properties
  localRepository: _propTypes["default"].object.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  workdirPath: _propTypes["default"].string,
  issueishNumber: _propTypes["default"].number.isRequired,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentsTotalCount: _propTypes["default"].number.isRequired,
  reviewCommentsResolvedCount: _propTypes["default"].number.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  onTitleChange: _propTypes["default"].func.isRequired,
  switchToIssueish: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishDetailController, {
  repository: function () {
    const node = require("./__generated__/issueishDetailController_repository.graphql");

    if (node.hash && node.hash !== "504a7b23eb6c4c87798663e4d9c7136a") {
      console.error("The definition of 'issueishDetailController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishDetailController_repository.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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