"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _githubTabView = _interopRequireDefault(require("../views/github-tab-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handlePushBranch", (currentBranch, targetRemote) => {
      return this.props.repository.push(currentBranch.getName(), {
        remote: targetRemote,
        setUpstream: true
      });
    });

    _defineProperty(this, "handleRemoteSelect", (e, remote) => {
      e.preventDefault();
      return this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
    });
  }

  render() {
    const gitHubRemotes = this.props.allRemotes.filter(remote => remote.isGithubRepo());
    const currentBranch = this.props.branches.getHeadBranch();
    let currentRemote = gitHubRemotes.withName(this.props.selectedRemoteName);
    let manyRemotesAvailable = false;

    if (!currentRemote.isPresent() && gitHubRemotes.size() === 1) {
      currentRemote = Array.from(gitHubRemotes)[0];
    } else if (!currentRemote.isPresent() && gitHubRemotes.size() > 1) {
      manyRemotesAvailable = true;
    }

    return _react["default"].createElement(_githubTabView["default"], {
      workspace: this.props.workspace,
      remoteOperationObserver: this.props.remoteOperationObserver,
      loginModel: this.props.loginModel,
      rootHolder: this.props.rootHolder,
      workingDirectory: this.props.workingDirectory,
      branches: this.props.branches,
      currentBranch: currentBranch,
      remotes: gitHubRemotes,
      currentRemote: currentRemote,
      manyRemotesAvailable: manyRemotesAvailable,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      isLoading: this.props.isLoading,
      handlePushBranch: this.handlePushBranch,
      handleRemoteSelect: this.handleRemoteSelect
    });
  }

}

exports["default"] = GitHubTabController;

_defineProperty(GitHubTabController, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  allRemotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  selectedRemoteName: _propTypes["default"].string,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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