"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareEmojiReactionsController = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _emojiReactionsView = _interopRequireDefault(require("../views/emoji-reactions-view"));

var _addReaction = _interopRequireDefault(require("../mutations/add-reaction"));

var _removeReaction = _interopRequireDefault(require("../mutations/remove-reaction"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareEmojiReactionsController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "addReaction", async content => {
      try {
        await (0, _addReaction["default"])(this.props.relay.environment, this.props.reactable.id, content);
      } catch (err) {
        this.props.reportRelayError('Unable to add reaction emoji', err);
      }
    });

    _defineProperty(this, "removeReaction", async content => {
      try {
        await (0, _removeReaction["default"])(this.props.relay.environment, this.props.reactable.id, content);
      } catch (err) {
        this.props.reportRelayError('Unable to remove reaction emoji', err);
      }
    });
  }

  render() {
    return _react["default"].createElement(_emojiReactionsView["default"], _extends({
      addReaction: this.addReaction,
      removeReaction: this.removeReaction
    }, this.props));
  }

}

exports.BareEmojiReactionsController = BareEmojiReactionsController;

_defineProperty(BareEmojiReactionsController, "propTypes", {
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  reactable: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareEmojiReactionsController, {
  reactable: function () {
    const node = require("./__generated__/emojiReactionsController_reactable.graphql");

    if (node.hash && node.hash !== "cfdd39cd7aa02bce0bdcd52bc0154223") {
      console.error("The definition of 'emojiReactionsController_reactable' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/emojiReactionsController_reactable.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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