"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _marker = _interopRequireDefault(require("../atom/marker"));

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _commentGutterDecorationController = _interopRequireDefault(require("../controllers/comment-gutter-decoration-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class EditorCommentDecorationsController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openReviewThread", async threadId => {
      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      });

      const reviewsItem = await this.props.workspace.open(uri, {
        searchAllPanes: true
      });
      reviewsItem.jumpToThread(threadId);
      (0, _reporterProxy.addEvent)('open-review-thread', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    this.rangesByRootID = new Map();
  }

  shouldComponentUpdate(nextProps) {
    return translationDigestFrom(this.props) !== translationDigestFrom(nextProps);
  }

  render() {
    if (!this.props.commentTranslationsForPath) {
      return null;
    }

    if (this.props.commentTranslationsForPath.removed && this.props.threadsForPath.length > 0) {
      const [firstThread] = this.props.threadsForPath;
      return _react["default"].createElement(_marker["default"], {
        editor: this.props.editor,
        exclusive: true,
        invalidate: "surround",
        bufferRange: _atom.Range.fromObject([[0, 0], [0, 0]])
      }, _react["default"].createElement(_decoration["default"], {
        type: "block",
        editor: this.props.editor,
        className: "github-EditorComment-omitted"
      }, _react["default"].createElement("p", null, "This file has review comments, but its patch is too large for Atom to load."), _react["default"].createElement("p", null, "Review comments may still be viewed within", _react["default"].createElement("button", {
        className: "btn",
        onClick: () => this.openReviewThread(firstThread.threadID)
      }, "the review tab"), ".")));
    }

    return this.props.threadsForPath.map(thread => {
      const range = this.getRangeForThread(thread);

      if (!range) {
        return null;
      }

      return _react["default"].createElement(_react.Fragment, {
        key: `github-editor-review-decoration-${thread.rootCommentID}`
      }, _react["default"].createElement(_marker["default"], {
        editor: this.props.editor,
        exclusive: true,
        invalidate: "surround",
        bufferRange: range,
        didChange: evt => this.markerDidChange(thread.rootCommentID, evt)
      }, _react["default"].createElement(_decoration["default"], {
        type: "line",
        editor: this.props.editor,
        className: "github-editorCommentHighlight",
        omitEmptyLastRow: false
      })), _react["default"].createElement(_commentGutterDecorationController["default"], {
        commentRow: range.start.row,
        threadId: thread.threadID,
        editor: this.props.editor,
        workspace: this.props.workspace,
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir,
        parent: this.constructor.name
      }));
    });
  }

  markerDidChange(rootCommentID, {
    newRange
  }) {
    this.rangesByRootID.set(rootCommentID, _atom.Range.fromObject(newRange));
  }

  getRangeForThread(thread) {
    const translations = this.props.commentTranslationsForPath;

    if (thread.position === null) {
      this.rangesByRootID["delete"](thread.rootCommentID);
      return null;
    }

    let adjustedPosition = translations.diffToFilePosition.get(thread.position);

    if (!adjustedPosition) {
      this.rangesByRootID["delete"](thread.rootCommentID);
      return null;
    }

    if (translations.fileTranslations) {
      adjustedPosition = translations.fileTranslations.get(adjustedPosition).newPosition;

      if (!adjustedPosition) {
        this.rangesByRootID["delete"](thread.rootCommentID);
        return null;
      }
    }

    const editorRow = adjustedPosition - 1;
    let localRange = this.rangesByRootID.get(thread.rootCommentID);

    if (!localRange) {
      localRange = _atom.Range.fromObject([[editorRow, 0], [editorRow, Infinity]]);
      this.rangesByRootID.set(thread.rootCommentID, localRange);
    }

    return localRange;
  }

}

exports["default"] = EditorCommentDecorationsController;

_defineProperty(EditorCommentDecorationsController, "propTypes", {
  endpoint: _propTypes2.EndpointPropType.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  editor: _propTypes["default"].object.isRequired,
  threadsForPath: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    rootCommentID: _propTypes["default"].string.isRequired,
    position: _propTypes["default"].number,
    threadID: _propTypes["default"].string.isRequired
  })).isRequired,
  commentTranslationsForPath: _propTypes["default"].shape({
    diffToFilePosition: _propTypes["default"].shape({
      get: _propTypes["default"].func.isRequired
    }).isRequired,
    fileTranslations: _propTypes["default"].shape({
      get: _propTypes["default"].func.isRequired
    }),
    removed: _propTypes["default"].bool.isRequired,
    digest: _propTypes["default"].string
  })
});

function translationDigestFrom(props) {
  const translations = props.commentTranslationsForPath;
  return translations ? translations.digest : null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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