"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _multiFilePatchController = _interopRequireDefault(require("./multi-file-patch-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "surface", () => this.props.surfaceFileAtPath(this.props.relPath, this.props.stagingStatus));
  }

  render() {
    return _react["default"].createElement(_multiFilePatchController["default"], _extends({
      surface: this.surface
    }, this.props));
  }

}

exports["default"] = ChangedFileController;

_defineProperty(ChangedFileController, "propTypes", {
  repository: _propTypes["default"].object.isRequired,
  stagingStatus: _propTypes["default"].oneOf(['staged', 'unstaged']),
  relPath: _propTypes["default"].string.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  surfaceFileAtPath: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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