"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _whatTheDiff = require("what-the-diff");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _filter = require("../models/patch/filter");

var _patch = require("../models/patch");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestPatchContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      multiFilePatch: null,
      error: null,
      last: {
        url: null,
        patch: null,
        etag: null
      }
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.fetchDiff(this.state.last);
  }

  componentDidUpdate(prevProps) {
    const explicitRefetch = this.props.refetch && !prevProps.refetch;
    const requestedURLChange = this.state.last.url !== this.getDiffURL();

    if (explicitRefetch || requestedURLChange) {
      const {
        last
      } = this.state;
      this.setState({
        multiFilePatch: null,
        error: null,
        last: {
          url: this.getDiffURL(),
          patch: null,
          etag: null
        }
      });
      this.fetchDiff(last);
    }
  }

  componentWillUnmount() {
    this.mounted = false;
  }

  render() {
    return this.props.children(this.state.error, this.state.multiFilePatch);
  } // Generate a v3 GitHub API REST URL for the pull request resource.
  // Example: https://api.github.com/repos/atom/github/pulls/1829


  getDiffURL() {
    return this.props.endpoint.getRestURI('repos', this.props.owner, this.props.repo, 'pulls', this.props.number);
  }

  buildPatch(rawDiff) {
    const {
      filtered,
      removed
    } = (0, _filter.filter)(rawDiff);
    const diffs = (0, _whatTheDiff.parse)(filtered).map(diff => {
      // diff coming from API will have the defaul git diff prefixes a/ and b/ and use *nix-style / path separators.
      // e.g. a/dir/file1.js and b/dir/file2.js
      // see https://git-scm.com/docs/git-diff#_generating_patches_with_p
      return _objectSpread2({}, diff, {
        newPath: diff.newPath ? (0, _helpers.toNativePathSep)(diff.newPath.replace(/^[a|b]\//, '')) : diff.newPath,
        oldPath: diff.oldPath ? (0, _helpers.toNativePathSep)(diff.oldPath.replace(/^[a|b]\//, '')) : diff.oldPath
      });
    });
    const options = {
      preserveOriginal: true,
      removed
    };

    if (this.props.largeDiffThreshold) {
      options.largeDiffThreshold = this.props.largeDiffThreshold;
    }

    const mfp = (0, _patch.buildMultiFilePatch)(diffs, options);
    return mfp;
  }

  async fetchDiff(last) {
    const url = this.getDiffURL();
    let response;

    try {
      const headers = {
        Accept: 'application/vnd.github.v3.diff',
        Authorization: `bearer ${this.props.token}`
      };

      if (url === last.url && last.etag !== null) {
        headers['If-None-Match'] = last.etag;
      }

      response = await fetch(url, {
        headers
      });
    } catch (err) {
      return this.reportDiffError(`Network error encountered fetching the patch: ${err.message}.`, err);
    }

    if (response.status === 304) {
      // Not modified.
      if (!this.mounted) {
        return null;
      }

      return new Promise(resolve => this.setState({
        multiFilePatch: last.patch,
        error: null,
        last
      }));
    }

    if (!response.ok) {
      return this.reportDiffError(`Unable to fetch the diff for this pull request: ${response.statusText}.`);
    }

    try {
      const etag = response.headers.get('ETag');
      const rawDiff = await response.text();

      if (!this.mounted) {
        return null;
      }

      const multiFilePatch = this.buildPatch(rawDiff);
      return new Promise(resolve => this.setState({
        multiFilePatch,
        error: null,
        last: {
          url,
          patch: multiFilePatch,
          etag
        }
      }, resolve));
    } catch (err) {
      return this.reportDiffError('Unable to parse the diff for this pull request.', err);
    }
  }

  reportDiffError(message, error) {
    if (!this.mounted) {
      return null;
    }

    return new Promise(resolve => {
      if (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      }

      if (!this.mounted) {
        resolve();
        return;
      }

      this.setState({
        error: message
      }, resolve);
    });
  }

}

exports["default"] = PullRequestPatchContainer;

_defineProperty(PullRequestPatchContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Fetching and parsing
  refetch: _propTypes["default"].bool,
  largeDiffThreshold: _propTypes["default"].number,
  // Render prop. Called with (error or null, multiFilePatch or null)
  children: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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