"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _issueishDetailController = _interopRequireDefault(require("../controllers/issueish-detail-controller"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithToken", tokenData => {
      const token = tokenData && tokenData.token;

      if (token instanceof Error) {
        return _react["default"].createElement(_queryErrorView["default"], {
          error: token,
          login: this.handleLogin,
          retry: this.handleTokenRetry,
          logout: this.handleLogout
        });
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      return _react["default"].createElement(_observeModel["default"], {
        model: this.props.repository,
        fetchData: this.fetchRepositoryData
      }, repoData => this.renderWithRepositoryData(token, repoData));
    });

    _defineProperty(this, "fetchToken", loginModel => {
      return (0, _yubikiri["default"])({
        token: loginModel.getToken(this.props.endpoint.getLoginAccount())
      });
    });

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing(),
        isAbsent: repository.isAbsent(),
        isLoading: repository.isLoading(),
        isPresent: repository.isPresent()
      });
    });

    _defineProperty(this, "handleLogin", token => this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token));

    _defineProperty(this, "handleLogout", () => this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithRepositoryData(token, repoData) {
    if (!token) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishDetailContainerQuery.graphql");

      if (node.hash && node.hash !== "c65534cd8bf43f640862f89187b6ff64") {
        console.error("The definition of 'issueishDetailContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishDetailContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      timelineCount: _helpers.PAGE_SIZE,
      timelineCursor: null,
      commitCount: _helpers.PAGE_SIZE,
      commitCursor: null,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null,
      checkSuiteCount: _helpers.CHECK_SUITE_PAGE_SIZE,
      checkSuiteCursor: null,
      checkRunCount: _helpers.CHECK_RUN_PAGE_SIZE,
      checkRunCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithQueryResult(token, repoData, queryResult)
    }));
  }

  renderWithQueryResult(token, repoData, {
    error,
    props,
    retry
  }) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props || !repoData) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    if (props.repository.issueish.__typename === 'PullRequest') {
      return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
        pullRequest: props.repository.issueish,
        reportRelayError: this.props.reportRelayError
      }, aggregatedReviews => this.renderWithCommentResult(token, repoData, {
        props,
        retry
      }, aggregatedReviews));
    } else {
      return this.renderWithCommentResult(token, repoData, {
        props,
        retry
      }, {
        errors: [],
        commentThreads: [],
        loading: false
      });
    }
  }

  renderWithCommentResult(token, repoData, {
    props,
    retry
  }, {
    errors,
    commentThreads,
    loading
  }) {
    const nonEmptyThreads = commentThreads.filter(each => each.comments && each.comments.length > 0);
    const totalCount = nonEmptyThreads.length;
    const resolvedCount = nonEmptyThreads.filter(each => each.thread.isResolved).length;

    if (errors && errors.length > 0) {
      const descriptions = errors.map(error => error.toString());
      return _react["default"].createElement(_errorView["default"], {
        title: "Unable to fetch review comments",
        descriptions: descriptions,
        retry: retry,
        logout: this.handleLogout
      });
    }

    return _react["default"].createElement(_issueishDetailController["default"], _extends({}, props, repoData, {
      reviewCommentsLoading: loading,
      reviewCommentsTotalCount: totalCount,
      reviewCommentsResolvedCount: resolvedCount,
      reviewCommentThreads: nonEmptyThreads,
      token: token,
      localRepository: this.props.repository,
      workdirPath: this.props.repository.getWorkingDirectoryPath(),
      issueishNumber: this.props.issueishNumber,
      onTitleChange: this.props.onTitleChange,
      switchToIssueish: this.props.switchToIssueish,
      initChangedFilePath: this.props.initChangedFilePath,
      initChangedFilePosition: this.props.initChangedFilePosition,
      selectedTab: this.props.selectedTab,
      onTabSelected: this.props.onTabSelected,
      onOpenFilesTab: this.props.onOpenFilesTab,
      endpoint: this.props.endpoint,
      reportRelayError: this.props.reportRelayError,
      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      itemType: this.props.itemType,
      destroy: this.props.destroy,
      refEditor: this.props.refEditor
    }));
  }

}

exports["default"] = IssueishDetailContainer;

_defineProperty(IssueishDetailContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Issueish selection criteria
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  issueishNumber: _propTypes["default"].number.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  selectedTab: _propTypes["default"].number.isRequired,
  onTabSelected: _propTypes["default"].func.isRequired,
  onOpenFilesTab: _propTypes["default"].func.isRequired,
  // Package models
  repository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  switchToIssueish: _propTypes["default"].func.isRequired,
  onTitleChange: _propTypes["default"].func.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  refEditor: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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