"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _commitDetailController = _interopRequireDefault(require("../controllers/commit-detail-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailContainer extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri["default"])({
        commit: repository.getCommit(this.props.sha),
        currentBranch: repository.getCurrentBranch(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        isCommitPushed: repository.isCommitPushed(this.props.sha)
      });
    });

    _defineProperty(this, "renderResult", data => {
      const currentCommit = data && data.commit;

      if (currentCommit !== this.lastCommit) {
        this.sub.dispose();

        if (currentCommit && currentCommit.isPresent()) {
          this.sub = new _eventKit.CompositeDisposable(...currentCommit.getMultiFileDiff().getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => {
            this.forceUpdate();
          })));
        }

        this.lastCommit = currentCommit;
      }

      if (this.props.repository.isLoading() || data === null || !data.commit.isPresent()) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      return _react["default"].createElement(_commitDetailController["default"], _extends({}, data, this.props));
    });

    this.lastCommit = null;
    this.sub = new _eventKit.CompositeDisposable();
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchData
    }, this.renderResult);
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports["default"] = CommitDetailContainer;

_defineProperty(CommitDetailContainer, "propTypes", {
  repository: _propTypes["default"].object.isRequired,
  sha: _propTypes["default"].string.isRequired,
  itemType: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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