"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _changedFileController = _interopRequireDefault(require("../controllers/changed-file-controller"));

var _patchBuffer = _interopRequireDefault(require("../models/patch/patch-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileContainer extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onWillUpdatePatch", cb => this.emitter.on('will-update-patch', cb));

    _defineProperty(this, "onDidUpdatePatch", cb => this.emitter.on('did-update-patch', cb));

    (0, _helpers.autobind)(this, 'fetchData', 'renderWithData');
    this.emitter = new _eventKit.Emitter();
    this.patchBuffer = new _patchBuffer["default"]();
    this.lastMultiFilePatch = null;
    this.sub = new _eventKit.CompositeDisposable();
    this.state = {
      renderStatusOverride: null
    };
  }

  fetchData(repository) {
    const staged = this.props.stagingStatus === 'staged';
    const builderOpts = {};

    if (this.state.renderStatusOverride !== null) {
      builderOpts.renderStatusOverrides = {
        [this.props.relPath]: this.state.renderStatusOverride
      };
    }

    if (this.props.largeDiffThreshold !== undefined) {
      builderOpts.largeDiffThreshold = this.props.largeDiffThreshold;
    }

    const before = () => this.emitter.emit('will-update-patch');

    const after = patch => this.emitter.emit('did-update-patch', patch);

    return (0, _yubikiri["default"])({
      multiFilePatch: repository.getFilePatchForPath(this.props.relPath, {
        staged,
        patchBuffer: this.patchBuffer,
        builder: builderOpts,
        before,
        after
      }),
      isPartiallyStaged: repository.isPartiallyStaged(this.props.relPath),
      hasUndoHistory: repository.hasDiscardHistory(this.props.relPath)
    });
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchData
    }, this.renderWithData);
  }

  renderWithData(data) {
    const currentMultiFilePatch = data && data.multiFilePatch;

    if (currentMultiFilePatch !== this.lastMultiFilePatch) {
      this.sub.dispose();
      /* istanbul ignore else */

      if (currentMultiFilePatch) {
        // Keep this component's renderStatusOverride synchronized with the FilePatch we're rendering
        this.sub = new _eventKit.CompositeDisposable(...currentMultiFilePatch.getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => {
          this.setState({
            renderStatusOverride: fp.getRenderStatus()
          });
        })));
      }

      this.lastMultiFilePatch = currentMultiFilePatch;
    }

    if (this.props.repository.isLoading() || data === null) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    return _react["default"].createElement(_changedFileController["default"], _extends({
      onWillUpdatePatch: this.onWillUpdatePatch,
      onDidUpdatePatch: this.onDidUpdatePatch
    }, data, this.props));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports["default"] = ChangedFileContainer;

_defineProperty(ChangedFileContainer, "propTypes", {
  repository: _propTypes["default"].object.isRequired,
  stagingStatus: _propTypes["default"].oneOf(['staged', 'unstaged']),
  relPath: _propTypes["default"].string.isRequired,
  largeDiffThreshold: _propTypes["default"].number,
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  destroy: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  surfaceFileAtPath: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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