"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewSummariesAccumulator = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _reactRelay = require("react-relay");

var _helpers = require("../../helpers");

var _propTypes2 = require("../../prop-types");

var _accumulator = _interopRequireDefault(require("./accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareReviewSummariesAccumulator extends _react["default"].Component {
  render() {
    const resultBatch = this.props.pullRequest.reviews.edges.map(edge => edge.node);
    return _react["default"].createElement(_accumulator["default"], {
      relay: this.props.relay,
      resultBatch: resultBatch,
      onDidRefetch: this.props.onDidRefetch,
      pageSize: _helpers.PAGE_SIZE,
      waitTimeMs: _helpers.PAGINATION_WAIT_TIME_MS
    }, (error, results, loading) => {
      const summaries = results.sort((a, b) => (0, _moment["default"])(a.submittedAt, _moment["default"].ISO_8601) - (0, _moment["default"])(b.submittedAt, _moment["default"].ISO_8601));
      return this.props.children({
        error,
        summaries,
        loading
      });
    });
  }

}

exports.BareReviewSummariesAccumulator = BareReviewSummariesAccumulator;

_defineProperty(BareReviewSummariesAccumulator, "propTypes", {
  // Relay props
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  pullRequest: _propTypes["default"].shape({
    reviews: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].object)
  }),
  // Render prop. Called with {error: error or null, summaries: array of all reviews, loading}
  children: _propTypes["default"].func.isRequired,
  // Called right after refetch happens
  onDidRefetch: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createPaginationContainer)(BareReviewSummariesAccumulator, {
  pullRequest: function () {
    const node = require("./__generated__/reviewSummariesAccumulator_pullRequest.graphql");

    if (node.hash && node.hash !== "4ac732c2325cedd6e8e90bb5c140cc1a") {
      console.error("The definition of 'reviewSummariesAccumulator_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewSummariesAccumulator_pullRequest.graphql");
  }
}, {
  direction: 'forward',

  /* istanbul ignore next */
  getConnectionFromProps(props) {
    return props.pullRequest.reviews;
  },

  /* istanbul ignore next */
  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread2({}, prevVars, {
      totalCount
    });
  },

  /* istanbul ignore next */
  getVariables(props, {
    count,
    cursor
  }) {
    return {
      url: props.pullRequest.url,
      reviewCount: count,
      reviewCursor: cursor
    };
  },

  query: function () {
    const node = require("./__generated__/reviewSummariesAccumulatorQuery.graphql");

    if (node.hash && node.hash !== "74bb2a56369e3c54b76c4ce7c17f328e") {
      console.error("The definition of 'reviewSummariesAccumulatorQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewSummariesAccumulatorQuery.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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