"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCheckSuitesAccumulator = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../../helpers");

var _propTypes2 = require("../../prop-types");

var _checkRunsAccumulator = _interopRequireDefault(require("./check-runs-accumulator"));

var _accumulator = _interopRequireDefault(require("./accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCheckSuitesAccumulator extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderCheckSuites", (err, suites, loading) => {
      if (err) {
        return this.props.children({
          errors: [err],
          suites,
          runsBySuite: new Map(),
          loading
        });
      }

      return this.renderCheckSuite({
        errors: [],
        suites,
        runsBySuite: new Map(),
        loading
      }, suites);
    });
  }

  render() {
    const resultBatch = this.props.commit.checkSuites.edges.map(edge => edge.node);
    return _react["default"].createElement(_accumulator["default"], {
      relay: this.props.relay,
      resultBatch: resultBatch,
      onDidRefetch: this.props.onDidRefetch,
      pageSize: _helpers.PAGE_SIZE,
      waitTimeMs: _helpers.PAGINATION_WAIT_TIME_MS
    }, this.renderCheckSuites);
  }

  renderCheckSuite(payload, suites) {
    if (suites.length === 0) {
      return this.props.children(payload);
    }

    const [suite] = suites;
    return _react["default"].createElement(_checkRunsAccumulator["default"], {
      onDidRefetch: this.props.onDidRefetch,
      checkSuite: suite
    }, ({
      error,
      checkRuns,
      loading: runsLoading
    }) => {
      if (error) {
        payload.errors.push(error);
      }

      payload.runsBySuite.set(suite, checkRuns);
      payload.loading = payload.loading || runsLoading;
      return this.renderCheckSuite(payload, suites.slice(1));
    });
  }

}

exports.BareCheckSuitesAccumulator = BareCheckSuitesAccumulator;

_defineProperty(BareCheckSuitesAccumulator, "propTypes", {
  // Relay
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  commit: _propTypes["default"].shape({
    checkSuites: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].object)
  }).isRequired,
  // Render prop. Called with (array of errors, array of check suites, map of runs per suite, loading)
  children: _propTypes["default"].func.isRequired,
  // Subscribe to an event that will fire just after a Relay refetch container completes a refetch.
  onDidRefetch: _propTypes["default"].func
});

_defineProperty(BareCheckSuitesAccumulator, "defaultProps", {
  onDidRefetch:
  /* istanbul ignore next */
  () => new _eventKit.Disposable()
});

var _default = (0, _reactRelay.createPaginationContainer)(BareCheckSuitesAccumulator, {
  commit: function () {
    const node = require("./__generated__/checkSuitesAccumulator_commit.graphql");

    if (node.hash && node.hash !== "582abc8127f0f2f19fb0a6a531af5e06") {
      console.error("The definition of 'checkSuitesAccumulator_commit' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkSuitesAccumulator_commit.graphql");
  }
}, {
  direction: 'forward',

  /* istanbul ignore next */
  getConnectionFromProps(props) {
    return props.commit.checkSuites;
  },

  /* istanbul ignore next */
  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread2({}, prevVars, {
      totalCount
    });
  },

  /* istanbul ignore next */
  getVariables(props, {
    count,
    cursor
  }, fragmentVariables) {
    return {
      id: props.commit.id,
      checkSuiteCount: count,
      checkSuiteCursor: cursor,
      checkRunCount: fragmentVariables.checkRunCount
    };
  },

  query: function () {
    const node = require("./__generated__/checkSuitesAccumulatorQuery.graphql");

    if (node.hash && node.hash !== "b27827b6adb558a64ae6da715a8e438e") {
      console.error("The definition of 'checkSuitesAccumulatorQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/checkSuitesAccumulatorQuery.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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