"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const VERBATIM_OPTION_PROPS = ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'];
const OPTION_PROPS = [...VERBATIM_OPTION_PROPS, 'tooltips', 'className', 'showDelay', 'hideDelay'];

class Tooltip extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    this.refSub = new _eventKit.Disposable();
    this.tipSub = new _eventKit.Disposable();
    this.domNode = null;

    if (this.props.children !== undefined) {
      this.domNode = document.createElement('div');
      this.domNode.className = 'react-atom-tooltip';
    }

    this.lastTooltipProps = {};
  }

  componentDidMount() {
    this.setupTooltip();
  }

  render() {
    if (this.props.children !== undefined) {
      return _reactDom["default"].createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  componentDidUpdate() {
    if (this.shouldRecreateTooltip()) {
      this.refSub.dispose();
      this.tipSub.dispose();
      this.setupTooltip();
    }
  }

  componentWillUnmount() {
    this.refSub.dispose();
    this.tipSub.dispose();
  }

  getTooltipProps() {
    const p = {};

    for (const key of OPTION_PROPS) {
      p[key] = this.props[key];
    }

    return p;
  }

  shouldRecreateTooltip() {
    return OPTION_PROPS.some(key => this.lastTooltipProps[key] !== this.props[key]);
  }

  setupTooltip() {
    this.lastTooltipProps = this.getTooltipProps();
    const options = {};
    VERBATIM_OPTION_PROPS.forEach(key => {
      if (this.props[key] !== undefined) {
        options[key] = this.props[key];
      }
    });

    if (this.props.className !== undefined) {
      options["class"] = this.props.className;
    }

    if (this.props.showDelay !== undefined || this.props.hideDelay !== undefined) {
      const delayDefaults = (this.props.trigger === 'hover' || this.props.trigger === undefined) && {
        show: 1000,
        hide: 100
      } || {
        show: 0,
        hide: 0
      };
      options.delay = {
        show: this.props.showDelay !== undefined ? this.props.showDelay : delayDefaults.show,
        hide: this.props.hideDelay !== undefined ? this.props.hideDelay : delayDefaults.hide
      };
    }

    if (this.props.children !== undefined) {
      options.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    this.refSub = this.props.target.observe(t => {
      this.tipSub.dispose();
      this.tipSub = this.props.manager.add(t, options);
      const h = this.props.tooltipHolder;

      if (h) {
        h.setter(this.tipSub);
      }
    });
  }

}

exports["default"] = Tooltip;

_defineProperty(Tooltip, "propTypes", {
  manager: _propTypes["default"].object.isRequired,
  target: _propTypes2.RefHolderPropType.isRequired,
  title: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].func]),
  html: _propTypes["default"].bool,
  className: _propTypes["default"].string,
  placement: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].func]),
  trigger: _propTypes["default"].oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes["default"].number,
  hideDelay: _propTypes["default"].number,
  keyBindingCommand: _propTypes["default"].string,
  keyBindingTarget: _propTypes["default"].element,
  children: _propTypes["default"].element,
  itemHolder: _propTypes2.RefHolderPropType,
  tooltipHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Tooltip, "defaultProps", {
  getItemComponent: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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