"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _marker = require("./marker");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const decorationPropTypes = {
  type: _propTypes["default"].oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes["default"].string,
  style: _propTypes["default"].string,
  onlyHead: _propTypes["default"].bool,
  onlyEmpty: _propTypes["default"].bool,
  onlyNonEmpty: _propTypes["default"].bool,
  omitEmptyLastRow: _propTypes["default"].bool,
  position: _propTypes["default"].oneOf(['head', 'tail', 'before', 'after']),
  order: _propTypes["default"].number,
  avoidOverflow: _propTypes["default"].bool,
  gutterName: _propTypes["default"].string
};

class BareDecoration extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "observeParents", () => {
      this.decorationHolder.map(decoration => decoration.destroy());
      const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
      const decorableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false); // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor

      const decorableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
        const layer = decorable.layer || decorable;
        const displayLayer = editor.getMarkerLayer(layer.id);

        if (!displayLayer) {
          return false;
        }

        if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
          return false;
        }

        return true;
      }).getOr(false)).getOr(false);

      if (!editorValid || !decorableValid || !decorableMatches) {
        return;
      } // delay decoration creation when it's a gutter type;
      // instead wait for the Gutter to be added to the editor first


      if (this.props.type === 'gutter') {
        if (!this.props.gutterName) {
          throw new Error('You are trying to decorate a gutter but did not supply gutterName prop.');
        }

        this.props.editorHolder.map(editor => {
          this.gutterSub = editor.observeGutters(gutter => {
            if (gutter.name === this.props.gutterName) {
              this.createDecoration();
            }
          });
          return null;
        });
        return;
      }

      this.createDecoration();
    });

    this.decorationHolder = new _refHolder["default"]();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();
    this.gutterSub = new _eventKit.Disposable();
    this.domNode = null;
    this.item = null;

    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames["default"])('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.props.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      this.decorationHolder.map(decoration => decoration.destroy());
      this.createDecoration();
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom["default"].createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  createDecoration() {
    if (this.usesItem() && !this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();
    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
    this.gutterSub.dispose();
  }

  getDecorationOpts(props) {
    return _objectSpread2({}, (0, _helpers.extractProps)(props, decorationPropTypes, {
      className: 'class'
    }), {
      item: this.item
    });
  }

}

_defineProperty(BareDecoration, "propTypes", _objectSpread2({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  decorableHolder: _propTypes2.RefHolderPropType.isRequired,
  decorateMethod: _propTypes["default"].oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes2.RefHolderPropType,
  children: _propTypes["default"].node
}, decorationPropTypes));

_defineProperty(BareDecoration, "defaultProps", {
  decorateMethod: 'decorateMarker'
});

class Decoration extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder["default"].on(this.props.editor),
      decorableHolder: _refHolder["default"].on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};

    if (editorChanged) {
      nextState.editorHolder = _refHolder["default"].on(props.editor);
    }

    if (decorableChanged) {
      nextState.decorableHolder = _refHolder["default"].on(props.decorable);
    }

    return nextState;
  }

  render() {
    return _react["default"].createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react["default"].createElement(_marker.DecorableContext.Consumer, null, decorable => {
      let holder = null;
      let decorateMethod = null;

      if (!this.state.decorableHolder.isEmpty()) {
        holder = this.state.decorableHolder;
        decorateMethod = this.props.decorateMethod;
      } else {
        holder = decorable.holder;
        decorateMethod = decorable.decorateMethod;
      }

      return _react["default"].createElement(BareDecoration, _extends({
        editorHolder: editorHolder || this.state.editorHolder,
        decorableHolder: holder,
        decorateMethod: decorateMethod
      }, this.props));
    }));
  }

}

exports["default"] = Decoration;

_defineProperty(Decoration, "propTypes", {
  editor: _propTypes["default"].object,
  decorable: _propTypes["default"].object,
  decorateMethod: _propTypes["default"].oneOf(['decorateMarker', 'decorateMarkerLayer'])
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRlY29yYXRpb24uanMiXSwibmFtZXMiOlsiZGVjb3JhdGlvblByb3BUeXBlcyIsInR5cGUiLCJQcm9wVHlwZXMiLCJvbmVPZiIsImlzUmVxdWlyZWQiLCJjbGFzc05hbWUiLCJzdHJpbmciLCJzdHlsZSIsIm9ubHlIZWFkIiwiYm9vbCIsIm9ubHlFbXB0eSIsIm9ubHlOb25FbXB0eSIsIm9taXRFbXB0eUxhc3RSb3ciLCJwb3NpdGlvbiIsIm9yZGVyIiwibnVtYmVyIiwiYXZvaWRPdmVyZmxvdyIsImd1dHRlck5hbWUiLCJCYXJlRGVjb3JhdGlvbiIsIlJlYWN0IiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJwcm9wcyIsImNvbnRleHQiLCJkZWNvcmF0aW9uSG9sZGVyIiwibWFwIiwiZGVjb3JhdGlvbiIsImRlc3Ryb3kiLCJlZGl0b3JWYWxpZCIsImVkaXRvckhvbGRlciIsImVkaXRvciIsImlzRGVzdHJveWVkIiwiZ2V0T3IiLCJkZWNvcmFibGVWYWxpZCIsImRlY29yYWJsZUhvbGRlciIsImRlY29yYWJsZSIsImRlY29yYWJsZU1hdGNoZXMiLCJsYXllciIsImRpc3BsYXlMYXllciIsImdldE1hcmtlckxheWVyIiwiaWQiLCJidWZmZXJNYXJrZXJMYXllciIsIkVycm9yIiwiZ3V0dGVyU3ViIiwib2JzZXJ2ZUd1dHRlcnMiLCJndXR0ZXIiLCJuYW1lIiwiY3JlYXRlRGVjb3JhdGlvbiIsIlJlZkhvbGRlciIsImVkaXRvclN1YiIsIkRpc3Bvc2FibGUiLCJkZWNvcmFibGVTdWIiLCJkb21Ob2RlIiwiaXRlbSIsImluY2x1ZGVzIiwiZG9jdW1lbnQiLCJjcmVhdGVFbGVtZW50IiwidXNlc0l0ZW0iLCJjb21wb25lbnREaWRNb3VudCIsIm9ic2VydmUiLCJvYnNlcnZlUGFyZW50cyIsImNvbXBvbmVudERpZFVwZGF0ZSIsInByZXZQcm9wcyIsImRpc3Bvc2UiLCJPYmplY3QiLCJrZXlzIiwic29tZSIsImtleSIsInJlbmRlciIsIlJlYWN0RE9NIiwiY3JlYXRlUG9ydGFsIiwiY2hpbGRyZW4iLCJpdGVtSG9sZGVyIiwib3B0cyIsImdldERlY29yYXRpb25PcHRzIiwiZ2V0Iiwic2V0dGVyIiwiZGVjb3JhdGVNZXRob2QiLCJjb21wb25lbnRXaWxsVW5tb3VudCIsIlJlZkhvbGRlclByb3BUeXBlIiwibm9kZSIsIkRlY29yYXRpb24iLCJzdGF0ZSIsIm9uIiwiZ2V0RGVyaXZlZFN0YXRlRnJvbVByb3BzIiwiZWRpdG9yQ2hhbmdlZCIsInVuZGVmaW5lZCIsImRlY29yYWJsZUNoYW5nZWQiLCJuZXh0U3RhdGUiLCJob2xkZXIiLCJpc0VtcHR5Iiwib2JqZWN0Il0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBRUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7Ozs7Ozs7QUFFQSxNQUFNQSxtQkFBbUIsR0FBRztBQUMxQkMsRUFBQUEsSUFBSSxFQUFFQyxzQkFBVUMsS0FBVixDQUFnQixDQUFDLE1BQUQsRUFBUyxhQUFULEVBQXdCLFdBQXhCLEVBQXFDLFNBQXJDLEVBQWdELFFBQWhELEVBQTBELE9BQTFELENBQWhCLEVBQW9GQyxVQURoRTtBQUUxQkMsRUFBQUEsU0FBUyxFQUFFSCxzQkFBVUksTUFGSztBQUcxQkMsRUFBQUEsS0FBSyxFQUFFTCxzQkFBVUksTUFIUztBQUkxQkUsRUFBQUEsUUFBUSxFQUFFTixzQkFBVU8sSUFKTTtBQUsxQkMsRUFBQUEsU0FBUyxFQUFFUixzQkFBVU8sSUFMSztBQU0xQkUsRUFBQUEsWUFBWSxFQUFFVCxzQkFBVU8sSUFORTtBQU8xQkcsRUFBQUEsZ0JBQWdCLEVBQUVWLHNCQUFVTyxJQVBGO0FBUTFCSSxFQUFBQSxRQUFRLEVBQUVYLHNCQUFVQyxLQUFWLENBQWdCLENBQUMsTUFBRCxFQUFTLE1BQVQsRUFBaUIsUUFBakIsRUFBMkIsT0FBM0IsQ0FBaEIsQ0FSZ0I7QUFTMUJXLEVBQUFBLEtBQUssRUFBRVosc0JBQVVhLE1BVFM7QUFVMUJDLEVBQUFBLGFBQWEsRUFBRWQsc0JBQVVPLElBVkM7QUFXMUJRLEVBQUFBLFVBQVUsRUFBRWYsc0JBQVVJO0FBWEksQ0FBNUI7O0FBY0EsTUFBTVksY0FBTixTQUE2QkMsa0JBQU1DLFNBQW5DLENBQTZDO0FBYzNDQyxFQUFBQSxXQUFXLENBQUNDLEtBQUQsRUFBUUMsT0FBUixFQUFpQjtBQUMxQixVQUFNRCxLQUFOLEVBQWFDLE9BQWI7O0FBRDBCLDRDQXdEWCxNQUFNO0FBQ3JCLFdBQUtDLGdCQUFMLENBQXNCQyxHQUF0QixDQUEwQkMsVUFBVSxJQUFJQSxVQUFVLENBQUNDLE9BQVgsRUFBeEM7QUFFQSxZQUFNQyxXQUFXLEdBQUcsS0FBS04sS0FBTCxDQUFXTyxZQUFYLENBQXdCSixHQUF4QixDQUE0QkssTUFBTSxJQUFJLENBQUNBLE1BQU0sQ0FBQ0MsV0FBUCxFQUF2QyxFQUE2REMsS0FBN0QsQ0FBbUUsS0FBbkUsQ0FBcEI7QUFDQSxZQUFNQyxjQUFjLEdBQUcsS0FBS1gsS0FBTCxDQUFXWSxlQUFYLENBQTJCVCxHQUEzQixDQUErQlUsU0FBUyxJQUFJLENBQUNBLFNBQVMsQ0FBQ0osV0FBVixFQUE3QyxFQUFzRUMsS0FBdEUsQ0FBNEUsS0FBNUUsQ0FBdkIsQ0FKcUIsQ0FNckI7O0FBQ0EsWUFBTUksZ0JBQWdCLEdBQUcsS0FBS2QsS0FBTCxDQUFXWSxlQUFYLENBQTJCVCxHQUEzQixDQUErQlUsU0FBUyxJQUFJLEtBQUtiLEtBQUwsQ0FBV08sWUFBWCxDQUF3QkosR0FBeEIsQ0FBNEJLLE1BQU0sSUFBSTtBQUN6RyxjQUFNTyxLQUFLLEdBQUdGLFNBQVMsQ0FBQ0UsS0FBVixJQUFtQkYsU0FBakM7QUFDQSxjQUFNRyxZQUFZLEdBQUdSLE1BQU0sQ0FBQ1MsY0FBUCxDQUFzQkYsS0FBSyxDQUFDRyxFQUE1QixDQUFyQjs7QUFDQSxZQUFJLENBQUNGLFlBQUwsRUFBbUI7QUFDakIsaUJBQU8sS0FBUDtBQUNEOztBQUNELFlBQUlBLFlBQVksS0FBS0QsS0FBakIsSUFBMEJDLFlBQVksQ0FBQ0csaUJBQWIsS0FBbUNKLEtBQWpFLEVBQXdFO0FBQ3RFLGlCQUFPLEtBQVA7QUFDRDs7QUFDRCxlQUFPLElBQVA7QUFDRCxPQVZvRSxFQVVsRUwsS0FWa0UsQ0FVNUQsS0FWNEQsQ0FBNUMsRUFVUkEsS0FWUSxDQVVGLEtBVkUsQ0FBekI7O0FBWUEsVUFBSSxDQUFDSixXQUFELElBQWdCLENBQUNLLGNBQWpCLElBQW1DLENBQUNHLGdCQUF4QyxFQUEwRDtBQUN4RDtBQUNELE9BckJvQixDQXVCckI7QUFDQTs7O0FBQ0EsVUFBSSxLQUFLZCxLQUFMLENBQVdyQixJQUFYLEtBQW9CLFFBQXhCLEVBQWtDO0FBQ2hDLFlBQUksQ0FBQyxLQUFLcUIsS0FBTCxDQUFXTCxVQUFoQixFQUE0QjtBQUMxQixnQkFBTSxJQUFJeUIsS0FBSixDQUFVLHlFQUFWLENBQU47QUFDRDs7QUFDRCxhQUFLcEIsS0FBTCxDQUFXTyxZQUFYLENBQXdCSixHQUF4QixDQUE0QkssTUFBTSxJQUFJO0FBQ3BDLGVBQUthLFNBQUwsR0FBaUJiLE1BQU0sQ0FBQ2MsY0FBUCxDQUFzQkMsTUFBTSxJQUFJO0FBQy9DLGdCQUFJQSxNQUFNLENBQUNDLElBQVAsS0FBZ0IsS0FBS3hCLEtBQUwsQ0FBV0wsVUFBL0IsRUFBMkM7QUFDekMsbUJBQUs4QixnQkFBTDtBQUNEO0FBQ0YsV0FKZ0IsQ0FBakI7QUFLQSxpQkFBTyxJQUFQO0FBQ0QsU0FQRDtBQVFBO0FBQ0Q7O0FBRUQsV0FBS0EsZ0JBQUw7QUFDRCxLQWpHMkI7O0FBRzFCLFNBQUt2QixnQkFBTCxHQUF3QixJQUFJd0IscUJBQUosRUFBeEI7QUFDQSxTQUFLQyxTQUFMLEdBQWlCLElBQUlDLG9CQUFKLEVBQWpCO0FBQ0EsU0FBS0MsWUFBTCxHQUFvQixJQUFJRCxvQkFBSixFQUFwQjtBQUNBLFNBQUtQLFNBQUwsR0FBaUIsSUFBSU8sb0JBQUosRUFBakI7QUFFQSxTQUFLRSxPQUFMLEdBQWUsSUFBZjtBQUNBLFNBQUtDLElBQUwsR0FBWSxJQUFaOztBQUVBLFFBQUksQ0FBQyxRQUFELEVBQVcsU0FBWCxFQUFzQixPQUF0QixFQUErQkMsUUFBL0IsQ0FBd0MsS0FBS2hDLEtBQUwsQ0FBV3JCLElBQW5ELENBQUosRUFBOEQ7QUFDNUQsV0FBS21ELE9BQUwsR0FBZUcsUUFBUSxDQUFDQyxhQUFULENBQXVCLEtBQXZCLENBQWY7QUFDQSxXQUFLSixPQUFMLENBQWEvQyxTQUFiLEdBQXlCLDRCQUFHLHVCQUFILEVBQTRCLEtBQUtpQixLQUFMLENBQVdqQixTQUF2QyxDQUF6QjtBQUNEO0FBQ0Y7O0FBRURvRCxFQUFBQSxRQUFRLEdBQUc7QUFDVCxXQUFPLEtBQUtMLE9BQUwsS0FBaUIsSUFBeEI7QUFDRDs7QUFFRE0sRUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsU0FBS1QsU0FBTCxHQUFpQixLQUFLM0IsS0FBTCxDQUFXTyxZQUFYLENBQXdCOEIsT0FBeEIsQ0FBZ0MsS0FBS0MsY0FBckMsQ0FBakI7QUFDQSxTQUFLVCxZQUFMLEdBQW9CLEtBQUs3QixLQUFMLENBQVdZLGVBQVgsQ0FBMkJ5QixPQUEzQixDQUFtQyxLQUFLQyxjQUF4QyxDQUFwQjtBQUNEOztBQUVEQyxFQUFBQSxrQkFBa0IsQ0FBQ0MsU0FBRCxFQUFZO0FBQzVCLFFBQUksS0FBS3hDLEtBQUwsQ0FBV08sWUFBWCxLQUE0QmlDLFNBQVMsQ0FBQ2pDLFlBQTFDLEVBQXdEO0FBQ3RELFdBQUtvQixTQUFMLENBQWVjLE9BQWY7QUFDQSxXQUFLZCxTQUFMLEdBQWlCLEtBQUszQixLQUFMLENBQVdPLFlBQVgsQ0FBd0I4QixPQUF4QixDQUFnQyxLQUFLQyxjQUFyQyxDQUFqQjtBQUNEOztBQUVELFFBQUksS0FBS3RDLEtBQUwsQ0FBV1ksZUFBWCxLQUErQjRCLFNBQVMsQ0FBQzVCLGVBQTdDLEVBQThEO0FBQzVELFdBQUtpQixZQUFMLENBQWtCWSxPQUFsQjtBQUNBLFdBQUtaLFlBQUwsR0FBb0IsS0FBSzdCLEtBQUwsQ0FBV1ksZUFBWCxDQUEyQnlCLE9BQTNCLENBQW1DLEtBQUtDLGNBQXhDLENBQXBCO0FBQ0Q7O0FBRUQsUUFDRUksTUFBTSxDQUFDQyxJQUFQLENBQVlqRSxtQkFBWixFQUFpQ2tFLElBQWpDLENBQXNDQyxHQUFHLElBQUksS0FBSzdDLEtBQUwsQ0FBVzZDLEdBQVgsTUFBb0JMLFNBQVMsQ0FBQ0ssR0FBRCxDQUExRSxDQURGLEVBRUU7QUFDQSxXQUFLM0MsZ0JBQUwsQ0FBc0JDLEdBQXRCLENBQTBCQyxVQUFVLElBQUlBLFVBQVUsQ0FBQ0MsT0FBWCxFQUF4QztBQUNBLFdBQUtvQixnQkFBTDtBQUNEO0FBQ0Y7O0FBRURxQixFQUFBQSxNQUFNLEdBQUc7QUFDUCxRQUFJLEtBQUtYLFFBQUwsRUFBSixFQUFxQjtBQUNuQixhQUFPWSxxQkFBU0MsWUFBVCxDQUNMLEtBQUtoRCxLQUFMLENBQVdpRCxRQUROLEVBRUwsS0FBS25CLE9BRkEsQ0FBUDtBQUlELEtBTEQsTUFLTztBQUNMLGFBQU8sSUFBUDtBQUNEO0FBQ0Y7O0FBNkNETCxFQUFBQSxnQkFBZ0IsR0FBRztBQUNqQixRQUFJLEtBQUtVLFFBQUwsTUFBbUIsQ0FBQyxLQUFLSixJQUE3QixFQUFtQztBQUNqQyxXQUFLQSxJQUFMLEdBQVkseUJBQVcsS0FBS0QsT0FBaEIsRUFBeUIsS0FBSzlCLEtBQUwsQ0FBV2tELFVBQXBDLENBQVo7QUFDRDs7QUFFRCxVQUFNQyxJQUFJLEdBQUcsS0FBS0MsaUJBQUwsQ0FBdUIsS0FBS3BELEtBQTVCLENBQWI7QUFDQSxVQUFNUSxNQUFNLEdBQUcsS0FBS1IsS0FBTCxDQUFXTyxZQUFYLENBQXdCOEMsR0FBeEIsRUFBZjtBQUNBLFVBQU14QyxTQUFTLEdBQUcsS0FBS2IsS0FBTCxDQUFXWSxlQUFYLENBQTJCeUMsR0FBM0IsRUFBbEI7QUFDQSxTQUFLbkQsZ0JBQUwsQ0FBc0JvRCxNQUF0QixDQUNFOUMsTUFBTSxDQUFDLEtBQUtSLEtBQUwsQ0FBV3VELGNBQVosQ0FBTixDQUFrQzFDLFNBQWxDLEVBQTZDc0MsSUFBN0MsQ0FERjtBQUdEOztBQUVESyxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLdEQsZ0JBQUwsQ0FBc0JDLEdBQXRCLENBQTBCQyxVQUFVLElBQUlBLFVBQVUsQ0FBQ0MsT0FBWCxFQUF4QztBQUNBLFNBQUtzQixTQUFMLENBQWVjLE9BQWY7QUFDQSxTQUFLWixZQUFMLENBQWtCWSxPQUFsQjtBQUNBLFNBQUtwQixTQUFMLENBQWVvQixPQUFmO0FBQ0Q7O0FBRURXLEVBQUFBLGlCQUFpQixDQUFDcEQsS0FBRCxFQUFRO0FBQ3ZCLDhCQUNLLDJCQUFhQSxLQUFiLEVBQW9CdEIsbUJBQXBCLEVBQXlDO0FBQUNLLE1BQUFBLFNBQVMsRUFBRTtBQUFaLEtBQXpDLENBREw7QUFFRWdELE1BQUFBLElBQUksRUFBRSxLQUFLQTtBQUZiO0FBSUQ7O0FBMUkwQzs7Z0JBQXZDbkMsYztBQUVGVyxFQUFBQSxZQUFZLEVBQUVrRCw4QkFBa0IzRSxVO0FBQ2hDOEIsRUFBQUEsZUFBZSxFQUFFNkMsOEJBQWtCM0UsVTtBQUNuQ3lFLEVBQUFBLGNBQWMsRUFBRTNFLHNCQUFVQyxLQUFWLENBQWdCLENBQUMsZ0JBQUQsRUFBbUIscUJBQW5CLENBQWhCLEM7QUFDaEJxRSxFQUFBQSxVQUFVLEVBQUVPLDZCO0FBQ1pSLEVBQUFBLFFBQVEsRUFBRXJFLHNCQUFVOEU7R0FDakJoRixtQjs7Z0JBUERrQixjLGtCQVVrQjtBQUNwQjJELEVBQUFBLGNBQWMsRUFBRTtBQURJLEM7O0FBbUlULE1BQU1JLFVBQU4sU0FBeUI5RCxrQkFBTUMsU0FBL0IsQ0FBeUM7QUFPdERDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47QUFFQSxTQUFLNEQsS0FBTCxHQUFhO0FBQ1hyRCxNQUFBQSxZQUFZLEVBQUVtQixzQkFBVW1DLEVBQVYsQ0FBYSxLQUFLN0QsS0FBTCxDQUFXUSxNQUF4QixDQURIO0FBRVhJLE1BQUFBLGVBQWUsRUFBRWMsc0JBQVVtQyxFQUFWLENBQWEsS0FBSzdELEtBQUwsQ0FBV2EsU0FBeEI7QUFGTixLQUFiO0FBSUQ7O0FBRUQsU0FBT2lELHdCQUFQLENBQWdDOUQsS0FBaEMsRUFBdUM0RCxLQUF2QyxFQUE4QztBQUM1QyxVQUFNRyxhQUFhLEdBQUdILEtBQUssQ0FBQ3JELFlBQU4sQ0FDbkJKLEdBRG1CLENBQ2ZLLE1BQU0sSUFBSUEsTUFBTSxLQUFLUixLQUFLLENBQUNRLE1BRFosRUFFbkJFLEtBRm1CLENBRWJWLEtBQUssQ0FBQ1EsTUFBTixLQUFpQndELFNBRkosQ0FBdEI7QUFHQSxVQUFNQyxnQkFBZ0IsR0FBR0wsS0FBSyxDQUFDaEQsZUFBTixDQUN0QlQsR0FEc0IsQ0FDbEJVLFNBQVMsSUFBSUEsU0FBUyxLQUFLYixLQUFLLENBQUNhLFNBRGYsRUFFdEJILEtBRnNCLENBRWhCVixLQUFLLENBQUNhLFNBQU4sS0FBb0JtRCxTQUZKLENBQXpCOztBQUlBLFFBQUksQ0FBQ0QsYUFBRCxJQUFrQixDQUFDRSxnQkFBdkIsRUFBeUM7QUFDdkMsYUFBTyxJQUFQO0FBQ0Q7O0FBRUQsVUFBTUMsU0FBUyxHQUFHLEVBQWxCOztBQUNBLFFBQUlILGFBQUosRUFBbUI7QUFDakJHLE1BQUFBLFNBQVMsQ0FBQzNELFlBQVYsR0FBeUJtQixzQkFBVW1DLEVBQVYsQ0FBYTdELEtBQUssQ0FBQ1EsTUFBbkIsQ0FBekI7QUFDRDs7QUFDRCxRQUFJeUQsZ0JBQUosRUFBc0I7QUFDcEJDLE1BQUFBLFNBQVMsQ0FBQ3RELGVBQVYsR0FBNEJjLHNCQUFVbUMsRUFBVixDQUFhN0QsS0FBSyxDQUFDYSxTQUFuQixDQUE1QjtBQUNEOztBQUNELFdBQU9xRCxTQUFQO0FBQ0Q7O0FBRURwQixFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFLGdDQUFDLGlDQUFELENBQW1CLFFBQW5CLFFBQ0d2QyxZQUFZLElBQ1gsZ0NBQUMsd0JBQUQsQ0FBa0IsUUFBbEIsUUFDR00sU0FBUyxJQUFJO0FBQ1osVUFBSXNELE1BQU0sR0FBRyxJQUFiO0FBQ0EsVUFBSVosY0FBYyxHQUFHLElBQXJCOztBQUNBLFVBQUksQ0FBQyxLQUFLSyxLQUFMLENBQVdoRCxlQUFYLENBQTJCd0QsT0FBM0IsRUFBTCxFQUEyQztBQUN6Q0QsUUFBQUEsTUFBTSxHQUFHLEtBQUtQLEtBQUwsQ0FBV2hELGVBQXBCO0FBQ0EyQyxRQUFBQSxjQUFjLEdBQUcsS0FBS3ZELEtBQUwsQ0FBV3VELGNBQTVCO0FBQ0QsT0FIRCxNQUdPO0FBQ0xZLFFBQUFBLE1BQU0sR0FBR3RELFNBQVMsQ0FBQ3NELE1BQW5CO0FBQ0FaLFFBQUFBLGNBQWMsR0FBRzFDLFNBQVMsQ0FBQzBDLGNBQTNCO0FBQ0Q7O0FBRUQsYUFDRSxnQ0FBQyxjQUFEO0FBQ0UsUUFBQSxZQUFZLEVBQUVoRCxZQUFZLElBQUksS0FBS3FELEtBQUwsQ0FBV3JELFlBRDNDO0FBRUUsUUFBQSxlQUFlLEVBQUU0RCxNQUZuQjtBQUdFLFFBQUEsY0FBYyxFQUFFWjtBQUhsQixTQUlNLEtBQUt2RCxLQUpYLEVBREY7QUFRRCxLQXBCSCxDQUZKLENBREY7QUE0QkQ7O0FBbkVxRDs7OztnQkFBbkMyRCxVLGVBQ0E7QUFDakJuRCxFQUFBQSxNQUFNLEVBQUU1QixzQkFBVXlGLE1BREQ7QUFFakJ4RCxFQUFBQSxTQUFTLEVBQUVqQyxzQkFBVXlGLE1BRko7QUFHakJkLEVBQUFBLGNBQWMsRUFBRTNFLHNCQUFVQyxLQUFWLENBQWdCLENBQUMsZ0JBQUQsRUFBbUIscUJBQW5CLENBQWhCO0FBSEMsQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFJlYWN0RE9NIGZyb20gJ3JlYWN0LWRvbSc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtEaXNwb3NhYmxlfSBmcm9tICdldmVudC1raXQnO1xuaW1wb3J0IGN4IGZyb20gJ2NsYXNzbmFtZXMnO1xuXG5pbXBvcnQge2NyZWF0ZUl0ZW0sIGV4dHJhY3RQcm9wc30gZnJvbSAnLi4vaGVscGVycyc7XG5pbXBvcnQge1JlZkhvbGRlclByb3BUeXBlfSBmcm9tICcuLi9wcm9wLXR5cGVzJztcbmltcG9ydCB7VGV4dEVkaXRvckNvbnRleHR9IGZyb20gJy4vYXRvbS10ZXh0LWVkaXRvcic7XG5pbXBvcnQge0RlY29yYWJsZUNvbnRleHR9IGZyb20gJy4vbWFya2VyJztcbmltcG9ydCBSZWZIb2xkZXIgZnJvbSAnLi4vbW9kZWxzL3JlZi1ob2xkZXInO1xuXG5jb25zdCBkZWNvcmF0aW9uUHJvcFR5cGVzID0ge1xuICB0eXBlOiBQcm9wVHlwZXMub25lT2YoWydsaW5lJywgJ2xpbmUtbnVtYmVyJywgJ2hpZ2hsaWdodCcsICdvdmVybGF5JywgJ2d1dHRlcicsICdibG9jayddKS5pc1JlcXVpcmVkLFxuICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gIHN0eWxlOiBQcm9wVHlwZXMuc3RyaW5nLFxuICBvbmx5SGVhZDogUHJvcFR5cGVzLmJvb2wsXG4gIG9ubHlFbXB0eTogUHJvcFR5cGVzLmJvb2wsXG4gIG9ubHlOb25FbXB0eTogUHJvcFR5cGVzLmJvb2wsXG4gIG9taXRFbXB0eUxhc3RSb3c6IFByb3BUeXBlcy5ib29sLFxuICBwb3NpdGlvbjogUHJvcFR5cGVzLm9uZU9mKFsnaGVhZCcsICd0YWlsJywgJ2JlZm9yZScsICdhZnRlciddKSxcbiAgb3JkZXI6IFByb3BUeXBlcy5udW1iZXIsXG4gIGF2b2lkT3ZlcmZsb3c6IFByb3BUeXBlcy5ib29sLFxuICBndXR0ZXJOYW1lOiBQcm9wVHlwZXMuc3RyaW5nLFxufTtcblxuY2xhc3MgQmFyZURlY29yYXRpb24gZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIGVkaXRvckhvbGRlcjogUmVmSG9sZGVyUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBkZWNvcmFibGVIb2xkZXI6IFJlZkhvbGRlclByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgZGVjb3JhdGVNZXRob2Q6IFByb3BUeXBlcy5vbmVPZihbJ2RlY29yYXRlTWFya2VyJywgJ2RlY29yYXRlTWFya2VyTGF5ZXInXSksXG4gICAgaXRlbUhvbGRlcjogUmVmSG9sZGVyUHJvcFR5cGUsXG4gICAgY2hpbGRyZW46IFByb3BUeXBlcy5ub2RlLFxuICAgIC4uLmRlY29yYXRpb25Qcm9wVHlwZXMsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGRlY29yYXRlTWV0aG9kOiAnZGVjb3JhdGVNYXJrZXInLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG5cbiAgICB0aGlzLmRlY29yYXRpb25Ib2xkZXIgPSBuZXcgUmVmSG9sZGVyKCk7XG4gICAgdGhpcy5lZGl0b3JTdWIgPSBuZXcgRGlzcG9zYWJsZSgpO1xuICAgIHRoaXMuZGVjb3JhYmxlU3ViID0gbmV3IERpc3Bvc2FibGUoKTtcbiAgICB0aGlzLmd1dHRlclN1YiA9IG5ldyBEaXNwb3NhYmxlKCk7XG5cbiAgICB0aGlzLmRvbU5vZGUgPSBudWxsO1xuICAgIHRoaXMuaXRlbSA9IG51bGw7XG5cbiAgICBpZiAoWydndXR0ZXInLCAnb3ZlcmxheScsICdibG9jayddLmluY2x1ZGVzKHRoaXMucHJvcHMudHlwZSkpIHtcbiAgICAgIHRoaXMuZG9tTm9kZSA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpO1xuICAgICAgdGhpcy5kb21Ob2RlLmNsYXNzTmFtZSA9IGN4KCdyZWFjdC1hdG9tLWRlY29yYXRpb24nLCB0aGlzLnByb3BzLmNsYXNzTmFtZSk7XG4gICAgfVxuICB9XG5cbiAgdXNlc0l0ZW0oKSB7XG4gICAgcmV0dXJuIHRoaXMuZG9tTm9kZSAhPT0gbnVsbDtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMuZWRpdG9yU3ViID0gdGhpcy5wcm9wcy5lZGl0b3JIb2xkZXIub2JzZXJ2ZSh0aGlzLm9ic2VydmVQYXJlbnRzKTtcbiAgICB0aGlzLmRlY29yYWJsZVN1YiA9IHRoaXMucHJvcHMuZGVjb3JhYmxlSG9sZGVyLm9ic2VydmUodGhpcy5vYnNlcnZlUGFyZW50cyk7XG4gIH1cblxuICBjb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuZWRpdG9ySG9sZGVyICE9PSBwcmV2UHJvcHMuZWRpdG9ySG9sZGVyKSB7XG4gICAgICB0aGlzLmVkaXRvclN1Yi5kaXNwb3NlKCk7XG4gICAgICB0aGlzLmVkaXRvclN1YiA9IHRoaXMucHJvcHMuZWRpdG9ySG9sZGVyLm9ic2VydmUodGhpcy5vYnNlcnZlUGFyZW50cyk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMucHJvcHMuZGVjb3JhYmxlSG9sZGVyICE9PSBwcmV2UHJvcHMuZGVjb3JhYmxlSG9sZGVyKSB7XG4gICAgICB0aGlzLmRlY29yYWJsZVN1Yi5kaXNwb3NlKCk7XG4gICAgICB0aGlzLmRlY29yYWJsZVN1YiA9IHRoaXMucHJvcHMuZGVjb3JhYmxlSG9sZGVyLm9ic2VydmUodGhpcy5vYnNlcnZlUGFyZW50cyk7XG4gICAgfVxuXG4gICAgaWYgKFxuICAgICAgT2JqZWN0LmtleXMoZGVjb3JhdGlvblByb3BUeXBlcykuc29tZShrZXkgPT4gdGhpcy5wcm9wc1trZXldICE9PSBwcmV2UHJvcHNba2V5XSlcbiAgICApIHtcbiAgICAgIHRoaXMuZGVjb3JhdGlvbkhvbGRlci5tYXAoZGVjb3JhdGlvbiA9PiBkZWNvcmF0aW9uLmRlc3Ryb3koKSk7XG4gICAgICB0aGlzLmNyZWF0ZURlY29yYXRpb24oKTtcbiAgICB9XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgaWYgKHRoaXMudXNlc0l0ZW0oKSkge1xuICAgICAgcmV0dXJuIFJlYWN0RE9NLmNyZWF0ZVBvcnRhbChcbiAgICAgICAgdGhpcy5wcm9wcy5jaGlsZHJlbixcbiAgICAgICAgdGhpcy5kb21Ob2RlLFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICB9XG5cbiAgb2JzZXJ2ZVBhcmVudHMgPSAoKSA9PiB7XG4gICAgdGhpcy5kZWNvcmF0aW9uSG9sZGVyLm1hcChkZWNvcmF0aW9uID0+IGRlY29yYXRpb24uZGVzdHJveSgpKTtcblxuICAgIGNvbnN0IGVkaXRvclZhbGlkID0gdGhpcy5wcm9wcy5lZGl0b3JIb2xkZXIubWFwKGVkaXRvciA9PiAhZWRpdG9yLmlzRGVzdHJveWVkKCkpLmdldE9yKGZhbHNlKTtcbiAgICBjb25zdCBkZWNvcmFibGVWYWxpZCA9IHRoaXMucHJvcHMuZGVjb3JhYmxlSG9sZGVyLm1hcChkZWNvcmFibGUgPT4gIWRlY29yYWJsZS5pc0Rlc3Ryb3llZCgpKS5nZXRPcihmYWxzZSk7XG5cbiAgICAvLyBFbnN1cmUgdGhlIE1hcmtlciBvciBNYXJrZXJMYXllciBjb3JyZXNwb25kcyB0byB0aGUgY29udGV4dCdzIFRleHRFZGl0b3JcbiAgICBjb25zdCBkZWNvcmFibGVNYXRjaGVzID0gdGhpcy5wcm9wcy5kZWNvcmFibGVIb2xkZXIubWFwKGRlY29yYWJsZSA9PiB0aGlzLnByb3BzLmVkaXRvckhvbGRlci5tYXAoZWRpdG9yID0+IHtcbiAgICAgIGNvbnN0IGxheWVyID0gZGVjb3JhYmxlLmxheWVyIHx8IGRlY29yYWJsZTtcbiAgICAgIGNvbnN0IGRpc3BsYXlMYXllciA9IGVkaXRvci5nZXRNYXJrZXJMYXllcihsYXllci5pZCk7XG4gICAgICBpZiAoIWRpc3BsYXlMYXllcikge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG4gICAgICBpZiAoZGlzcGxheUxheWVyICE9PSBsYXllciAmJiBkaXNwbGF5TGF5ZXIuYnVmZmVyTWFya2VyTGF5ZXIgIT09IGxheWVyKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICAgIHJldHVybiB0cnVlO1xuICAgIH0pLmdldE9yKGZhbHNlKSkuZ2V0T3IoZmFsc2UpO1xuXG4gICAgaWYgKCFlZGl0b3JWYWxpZCB8fCAhZGVjb3JhYmxlVmFsaWQgfHwgIWRlY29yYWJsZU1hdGNoZXMpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICAvLyBkZWxheSBkZWNvcmF0aW9uIGNyZWF0aW9uIHdoZW4gaXQncyBhIGd1dHRlciB0eXBlO1xuICAgIC8vIGluc3RlYWQgd2FpdCBmb3IgdGhlIEd1dHRlciB0byBiZSBhZGRlZCB0byB0aGUgZWRpdG9yIGZpcnN0XG4gICAgaWYgKHRoaXMucHJvcHMudHlwZSA9PT0gJ2d1dHRlcicpIHtcbiAgICAgIGlmICghdGhpcy5wcm9wcy5ndXR0ZXJOYW1lKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignWW91IGFyZSB0cnlpbmcgdG8gZGVjb3JhdGUgYSBndXR0ZXIgYnV0IGRpZCBub3Qgc3VwcGx5IGd1dHRlck5hbWUgcHJvcC4nKTtcbiAgICAgIH1cbiAgICAgIHRoaXMucHJvcHMuZWRpdG9ySG9sZGVyLm1hcChlZGl0b3IgPT4ge1xuICAgICAgICB0aGlzLmd1dHRlclN1YiA9IGVkaXRvci5vYnNlcnZlR3V0dGVycyhndXR0ZXIgPT4ge1xuICAgICAgICAgIGlmIChndXR0ZXIubmFtZSA9PT0gdGhpcy5wcm9wcy5ndXR0ZXJOYW1lKSB7XG4gICAgICAgICAgICB0aGlzLmNyZWF0ZURlY29yYXRpb24oKTtcbiAgICAgICAgICB9XG4gICAgICAgIH0pO1xuICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgIH0pO1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIHRoaXMuY3JlYXRlRGVjb3JhdGlvbigpO1xuICB9XG5cbiAgY3JlYXRlRGVjb3JhdGlvbigpIHtcbiAgICBpZiAodGhpcy51c2VzSXRlbSgpICYmICF0aGlzLml0ZW0pIHtcbiAgICAgIHRoaXMuaXRlbSA9IGNyZWF0ZUl0ZW0odGhpcy5kb21Ob2RlLCB0aGlzLnByb3BzLml0ZW1Ib2xkZXIpO1xuICAgIH1cblxuICAgIGNvbnN0IG9wdHMgPSB0aGlzLmdldERlY29yYXRpb25PcHRzKHRoaXMucHJvcHMpO1xuICAgIGNvbnN0IGVkaXRvciA9IHRoaXMucHJvcHMuZWRpdG9ySG9sZGVyLmdldCgpO1xuICAgIGNvbnN0IGRlY29yYWJsZSA9IHRoaXMucHJvcHMuZGVjb3JhYmxlSG9sZGVyLmdldCgpO1xuICAgIHRoaXMuZGVjb3JhdGlvbkhvbGRlci5zZXR0ZXIoXG4gICAgICBlZGl0b3JbdGhpcy5wcm9wcy5kZWNvcmF0ZU1ldGhvZF0oZGVjb3JhYmxlLCBvcHRzKSxcbiAgICApO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5kZWNvcmF0aW9uSG9sZGVyLm1hcChkZWNvcmF0aW9uID0+IGRlY29yYXRpb24uZGVzdHJveSgpKTtcbiAgICB0aGlzLmVkaXRvclN1Yi5kaXNwb3NlKCk7XG4gICAgdGhpcy5kZWNvcmFibGVTdWIuZGlzcG9zZSgpO1xuICAgIHRoaXMuZ3V0dGVyU3ViLmRpc3Bvc2UoKTtcbiAgfVxuXG4gIGdldERlY29yYXRpb25PcHRzKHByb3BzKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLmV4dHJhY3RQcm9wcyhwcm9wcywgZGVjb3JhdGlvblByb3BUeXBlcywge2NsYXNzTmFtZTogJ2NsYXNzJ30pLFxuICAgICAgaXRlbTogdGhpcy5pdGVtLFxuICAgIH07XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRGVjb3JhdGlvbiBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgZWRpdG9yOiBQcm9wVHlwZXMub2JqZWN0LFxuICAgIGRlY29yYWJsZTogUHJvcFR5cGVzLm9iamVjdCxcbiAgICBkZWNvcmF0ZU1ldGhvZDogUHJvcFR5cGVzLm9uZU9mKFsnZGVjb3JhdGVNYXJrZXInLCAnZGVjb3JhdGVNYXJrZXJMYXllciddKSxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGVkaXRvckhvbGRlcjogUmVmSG9sZGVyLm9uKHRoaXMucHJvcHMuZWRpdG9yKSxcbiAgICAgIGRlY29yYWJsZUhvbGRlcjogUmVmSG9sZGVyLm9uKHRoaXMucHJvcHMuZGVjb3JhYmxlKSxcbiAgICB9O1xuICB9XG5cbiAgc3RhdGljIGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyhwcm9wcywgc3RhdGUpIHtcbiAgICBjb25zdCBlZGl0b3JDaGFuZ2VkID0gc3RhdGUuZWRpdG9ySG9sZGVyXG4gICAgICAubWFwKGVkaXRvciA9PiBlZGl0b3IgIT09IHByb3BzLmVkaXRvcilcbiAgICAgIC5nZXRPcihwcm9wcy5lZGl0b3IgIT09IHVuZGVmaW5lZCk7XG4gICAgY29uc3QgZGVjb3JhYmxlQ2hhbmdlZCA9IHN0YXRlLmRlY29yYWJsZUhvbGRlclxuICAgICAgLm1hcChkZWNvcmFibGUgPT4gZGVjb3JhYmxlICE9PSBwcm9wcy5kZWNvcmFibGUpXG4gICAgICAuZ2V0T3IocHJvcHMuZGVjb3JhYmxlICE9PSB1bmRlZmluZWQpO1xuXG4gICAgaWYgKCFlZGl0b3JDaGFuZ2VkICYmICFkZWNvcmFibGVDaGFuZ2VkKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG5cbiAgICBjb25zdCBuZXh0U3RhdGUgPSB7fTtcbiAgICBpZiAoZWRpdG9yQ2hhbmdlZCkge1xuICAgICAgbmV4dFN0YXRlLmVkaXRvckhvbGRlciA9IFJlZkhvbGRlci5vbihwcm9wcy5lZGl0b3IpO1xuICAgIH1cbiAgICBpZiAoZGVjb3JhYmxlQ2hhbmdlZCkge1xuICAgICAgbmV4dFN0YXRlLmRlY29yYWJsZUhvbGRlciA9IFJlZkhvbGRlci5vbihwcm9wcy5kZWNvcmFibGUpO1xuICAgIH1cbiAgICByZXR1cm4gbmV4dFN0YXRlO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8VGV4dEVkaXRvckNvbnRleHQuQ29uc3VtZXI+XG4gICAgICAgIHtlZGl0b3JIb2xkZXIgPT4gKFxuICAgICAgICAgIDxEZWNvcmFibGVDb250ZXh0LkNvbnN1bWVyPlxuICAgICAgICAgICAge2RlY29yYWJsZSA9PiB7XG4gICAgICAgICAgICAgIGxldCBob2xkZXIgPSBudWxsO1xuICAgICAgICAgICAgICBsZXQgZGVjb3JhdGVNZXRob2QgPSBudWxsO1xuICAgICAgICAgICAgICBpZiAoIXRoaXMuc3RhdGUuZGVjb3JhYmxlSG9sZGVyLmlzRW1wdHkoKSkge1xuICAgICAgICAgICAgICAgIGhvbGRlciA9IHRoaXMuc3RhdGUuZGVjb3JhYmxlSG9sZGVyO1xuICAgICAgICAgICAgICAgIGRlY29yYXRlTWV0aG9kID0gdGhpcy5wcm9wcy5kZWNvcmF0ZU1ldGhvZDtcbiAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBob2xkZXIgPSBkZWNvcmFibGUuaG9sZGVyO1xuICAgICAgICAgICAgICAgIGRlY29yYXRlTWV0aG9kID0gZGVjb3JhYmxlLmRlY29yYXRlTWV0aG9kO1xuICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgICAgICA8QmFyZURlY29yYXRpb25cbiAgICAgICAgICAgICAgICAgIGVkaXRvckhvbGRlcj17ZWRpdG9ySG9sZGVyIHx8IHRoaXMuc3RhdGUuZWRpdG9ySG9sZGVyfVxuICAgICAgICAgICAgICAgICAgZGVjb3JhYmxlSG9sZGVyPXtob2xkZXJ9XG4gICAgICAgICAgICAgICAgICBkZWNvcmF0ZU1ldGhvZD17ZGVjb3JhdGVNZXRob2R9XG4gICAgICAgICAgICAgICAgICB7Li4udGhpcy5wcm9wc31cbiAgICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgfX1cbiAgICAgICAgICA8L0RlY29yYWJsZUNvbnRleHQuQ29uc3VtZXI+XG4gICAgICAgICl9XG4gICAgICA8L1RleHRFZGl0b3JDb250ZXh0LkNvbnN1bWVyPlxuICAgICk7XG4gIH1cbn1cbiJdfQ==